/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_ASSOCIATED_PERSON;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_RX_ADMINISTRATION;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_RX_ORDER;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_STUDY;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.OBX;
import ca.uhn.hl7v2.model.v24.segment.PCR;
import ca.uhn.hl7v2.model.v24.segment.PRB;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEX_P07_PEX_CAUSE
extends AbstractGroup {
    public PEX_P07_PEX_CAUSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PCR.class, true, false, false);
            this.add(PEX_P07_RX_ORDER.class, false, false, false);
            this.add(PEX_P07_RX_ADMINISTRATION.class, false, true, false);
            this.add(PRB.class, false, true, false);
            this.add(OBX.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(PEX_P07_ASSOCIATED_PERSON.class, false, false, false);
            this.add(PEX_P07_STUDY.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PEX_P07_PEX_CAUSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PCR getPCR() {
        PCR retVal = this.getTyped("PCR", PCR.class);
        return retVal;
    }

    public PEX_P07_RX_ORDER getRX_ORDER() {
        PEX_P07_RX_ORDER retVal = this.getTyped("RX_ORDER", PEX_P07_RX_ORDER.class);
        return retVal;
    }

    public PEX_P07_RX_ADMINISTRATION getRX_ADMINISTRATION() {
        PEX_P07_RX_ADMINISTRATION retVal = this.getTyped("RX_ADMINISTRATION", PEX_P07_RX_ADMINISTRATION.class);
        return retVal;
    }

    public PEX_P07_RX_ADMINISTRATION getRX_ADMINISTRATION(int rep) {
        PEX_P07_RX_ADMINISTRATION retVal = this.getTyped("RX_ADMINISTRATION", rep, PEX_P07_RX_ADMINISTRATION.class);
        return retVal;
    }

    public int getRX_ADMINISTRATIONReps() {
        return this.getReps("RX_ADMINISTRATION");
    }

    public List<PEX_P07_RX_ADMINISTRATION> getRX_ADMINISTRATIONAll() throws HL7Exception {
        return this.getAllAsList("RX_ADMINISTRATION", PEX_P07_RX_ADMINISTRATION.class);
    }

    public void insertRX_ADMINISTRATION(PEX_P07_RX_ADMINISTRATION structure, int rep) throws HL7Exception {
        super.insertRepetition("RX_ADMINISTRATION", structure, rep);
    }

    public PEX_P07_RX_ADMINISTRATION insertRX_ADMINISTRATION(int rep) throws HL7Exception {
        return (PEX_P07_RX_ADMINISTRATION)super.insertRepetition("RX_ADMINISTRATION", rep);
    }

    public PEX_P07_RX_ADMINISTRATION removeRX_ADMINISTRATION(int rep) throws HL7Exception {
        return (PEX_P07_RX_ADMINISTRATION)super.removeRepetition("RX_ADMINISTRATION", rep);
    }

    public PRB getPRB() {
        PRB retVal = this.getTyped("PRB", PRB.class);
        return retVal;
    }

    public PRB getPRB(int rep) {
        PRB retVal = this.getTyped("PRB", rep, PRB.class);
        return retVal;
    }

    public int getPRBReps() {
        return this.getReps("PRB");
    }

    public List<PRB> getPRBAll() throws HL7Exception {
        return this.getAllAsList("PRB", PRB.class);
    }

    public void insertPRB(PRB structure, int rep) throws HL7Exception {
        super.insertRepetition("PRB", structure, rep);
    }

    public PRB insertPRB(int rep) throws HL7Exception {
        return (PRB)super.insertRepetition("PRB", rep);
    }

    public PRB removePRB(int rep) throws HL7Exception {
        return (PRB)super.removeRepetition("PRB", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PEX_P07_ASSOCIATED_PERSON getASSOCIATED_PERSON() {
        PEX_P07_ASSOCIATED_PERSON retVal = this.getTyped("ASSOCIATED_PERSON", PEX_P07_ASSOCIATED_PERSON.class);
        return retVal;
    }

    public PEX_P07_STUDY getSTUDY() {
        PEX_P07_STUDY retVal = this.getTyped("STUDY", PEX_P07_STUDY.class);
        return retVal;
    }

    public PEX_P07_STUDY getSTUDY(int rep) {
        PEX_P07_STUDY retVal = this.getTyped("STUDY", rep, PEX_P07_STUDY.class);
        return retVal;
    }

    public int getSTUDYReps() {
        return this.getReps("STUDY");
    }

    public List<PEX_P07_STUDY> getSTUDYAll() throws HL7Exception {
        return this.getAllAsList("STUDY", PEX_P07_STUDY.class);
    }

    public void insertSTUDY(PEX_P07_STUDY structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY", structure, rep);
    }

    public PEX_P07_STUDY insertSTUDY(int rep) throws HL7Exception {
        return (PEX_P07_STUDY)super.insertRepetition("STUDY", rep);
    }

    public PEX_P07_STUDY removeSTUDY(int rep) throws HL7Exception {
        return (PEX_P07_STUDY)super.removeRepetition("STUDY", rep);
    }
}

