/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.DT;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.OCD;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.UVC;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class UB1
extends AbstractSegment {
    public UB1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - UB1");
            this.add(NM.class, false, 1, 1, new Object[]{this.getMessage()}, "Blood Deductible  (43)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood Furnished-Pints Of (40)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood Replaced-Pints (41)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood Not Replaced-Pints(42)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Co-Insurance Days (25)");
            this.add(IS.class, false, 5, 14, new Object[]{this.getMessage(), new Integer(43)}, "Condition Code (35-39)");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Covered Days - (23)");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Non Covered Days - (24)");
            this.add(UVC.class, false, 8, 12, new Object[]{this.getMessage()}, "Value Amount & Code (46-49)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Number Of Grace Days (90)");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Special Program Indicator (44)");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "PSRO/UR Approval Indicator (87)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "PSRO/UR Approved Stay-Fm (88)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "PSRO/UR Approved Stay-To (89)");
            this.add(OCD.class, false, 5, 20, new Object[]{this.getMessage()}, "Occurrence (28-32)");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Occurrence Span (33)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Occur Span Start Date(33)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Occur Span End Date (33)");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "UB-82 Locator 2");
            this.add(ST.class, false, 1, 7, new Object[]{this.getMessage()}, "UB-82 Locator 9");
            this.add(ST.class, false, 1, 8, new Object[]{this.getMessage()}, "UB-82 Locator 27");
            this.add(ST.class, false, 1, 17, new Object[]{this.getMessage()}, "UB-82 Locator 45");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating UB1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDUB1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getUb11_SetIDUB1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getBloodDeductible() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getUb12_BloodDeductible() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getBloodFurnishedPintsOf() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getUb13_BloodFurnishedPintsOf() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getBloodReplacedPints() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getUb14_BloodReplacedPints() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getBloodNotReplacedPints() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getUb15_BloodNotReplacedPints() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getCoInsuranceDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getUb16_CoInsuranceDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public IS[] getConditionCode3539() {
        IS[] retVal = (IS[])this.getTypedField(7, new IS[0]);
        return retVal;
    }

    public IS[] getUb17_ConditionCode3539() {
        IS[] retVal = (IS[])this.getTypedField(7, new IS[0]);
        return retVal;
    }

    public int getConditionCode3539Reps() {
        return this.getReps(7);
    }

    public IS getConditionCode3539(int rep) {
        IS retVal = (IS)this.getTypedField(7, rep);
        return retVal;
    }

    public IS getUb17_ConditionCode3539(int rep) {
        IS retVal = (IS)this.getTypedField(7, rep);
        return retVal;
    }

    public int getUb17_ConditionCode3539Reps() {
        return this.getReps(7);
    }

    public IS insertConditionCode3539(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(7, rep);
    }

    public IS insertUb17_ConditionCode3539(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(7, rep);
    }

    public IS removeConditionCode3539(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(7, rep);
    }

    public IS removeUb17_ConditionCode3539(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(7, rep);
    }

    public NM getCoveredDays() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getUb18_CoveredDays() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getNonCoveredDays() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getUb19_NonCoveredDays() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public UVC[] getValueAmountCode4649() {
        UVC[] retVal = (UVC[])this.getTypedField(10, new UVC[0]);
        return retVal;
    }

    public UVC[] getUb110_ValueAmountCode4649() {
        UVC[] retVal = (UVC[])this.getTypedField(10, new UVC[0]);
        return retVal;
    }

    public int getValueAmountCode4649Reps() {
        return this.getReps(10);
    }

    public UVC getValueAmountCode4649(int rep) {
        UVC retVal = (UVC)this.getTypedField(10, rep);
        return retVal;
    }

    public UVC getUb110_ValueAmountCode4649(int rep) {
        UVC retVal = (UVC)this.getTypedField(10, rep);
        return retVal;
    }

    public int getUb110_ValueAmountCode4649Reps() {
        return this.getReps(10);
    }

    public UVC insertValueAmountCode4649(int rep) throws HL7Exception {
        return (UVC)super.insertRepetition(10, rep);
    }

    public UVC insertUb110_ValueAmountCode4649(int rep) throws HL7Exception {
        return (UVC)super.insertRepetition(10, rep);
    }

    public UVC removeValueAmountCode4649(int rep) throws HL7Exception {
        return (UVC)super.removeRepetition(10, rep);
    }

    public UVC removeUb110_ValueAmountCode4649(int rep) throws HL7Exception {
        return (UVC)super.removeRepetition(10, rep);
    }

    public NM getNumberOfGraceDays() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getUb111_NumberOfGraceDays() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getSpecialProgramIndicator() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getUb112_SpecialProgramIndicator() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getPSROURApprovalIndicator() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getUb113_PSROURApprovalIndicator() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getPSROURApprovedStayFm() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getUb114_PSROURApprovedStayFm() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getPSROURApprovedStayTo() {
        DT retVal = (DT)this.getTypedField(15, 0);
        return retVal;
    }

    public DT getUb115_PSROURApprovedStayTo() {
        DT retVal = (DT)this.getTypedField(15, 0);
        return retVal;
    }

    public OCD[] getOccurrence2832() {
        OCD[] retVal = (OCD[])this.getTypedField(16, new OCD[0]);
        return retVal;
    }

    public OCD[] getUb116_Occurrence2832() {
        OCD[] retVal = (OCD[])this.getTypedField(16, new OCD[0]);
        return retVal;
    }

    public int getOccurrence2832Reps() {
        return this.getReps(16);
    }

    public OCD getOccurrence2832(int rep) {
        OCD retVal = (OCD)this.getTypedField(16, rep);
        return retVal;
    }

    public OCD getUb116_Occurrence2832(int rep) {
        OCD retVal = (OCD)this.getTypedField(16, rep);
        return retVal;
    }

    public int getUb116_Occurrence2832Reps() {
        return this.getReps(16);
    }

    public OCD insertOccurrence2832(int rep) throws HL7Exception {
        return (OCD)super.insertRepetition(16, rep);
    }

    public OCD insertUb116_Occurrence2832(int rep) throws HL7Exception {
        return (OCD)super.insertRepetition(16, rep);
    }

    public OCD removeOccurrence2832(int rep) throws HL7Exception {
        return (OCD)super.removeRepetition(16, rep);
    }

    public OCD removeUb116_Occurrence2832(int rep) throws HL7Exception {
        return (OCD)super.removeRepetition(16, rep);
    }

    public CE getOccurrenceSpan() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getUb117_OccurrenceSpan() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getOccurSpanStartDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getUb118_OccurSpanStartDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getOccurSpanEndDate() {
        DT retVal = (DT)this.getTypedField(19, 0);
        return retVal;
    }

    public DT getUb119_OccurSpanEndDate() {
        DT retVal = (DT)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getUB82Locator2() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getUb120_UB82Locator2() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getUB82Locator9() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getUb121_UB82Locator9() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getUB82Locator27() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getUb122_UB82Locator27() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getUB82Locator45() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getUb123_UB82Locator45() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new IS(this.getMessage(), new Integer(43));
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new UVC(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new DT(this.getMessage());
            }
            case 15: {
                return new OCD(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new DT(this.getMessage());
            }
            case 18: {
                return new DT(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

