/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.ADT_A01_INSURANCE;
import ca.uhn.hl7v2.model.v25.group.ADT_A01_PROCEDURE;
import ca.uhn.hl7v2.model.v25.segment.ACC;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.model.v25.segment.DB1;
import ca.uhn.hl7v2.model.v25.segment.DG1;
import ca.uhn.hl7v2.model.v25.segment.DRG;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.GT1;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NK1;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.PD1;
import ca.uhn.hl7v2.model.v25.segment.PDA;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.PV1;
import ca.uhn.hl7v2.model.v25.segment.PV2;
import ca.uhn.hl7v2.model.v25.segment.ROL;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.model.v25.segment.UB1;
import ca.uhn.hl7v2.model.v25.segment.UB2;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A01
extends AbstractMessage {
    public ADT_A01() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ROL.class, false, true);
            this.add(NK1.class, false, true);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(ROL.class, false, true);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
            this.add(AL1.class, false, true);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, false);
            this.add(ADT_A01_PROCEDURE.class, false, true);
            this.add(GT1.class, false, true);
            this.add(ADT_A01_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
            this.add(UB1.class, false, false);
            this.add(UB2.class, false, false);
            this.add(PDA.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_A01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }

    public ROL getROL2() {
        return this.getTyped("ROL2", ROL.class);
    }

    public ROL getROL2(int rep) {
        return this.getTyped("ROL2", rep, ROL.class);
    }

    public int getROL2Reps() {
        return this.getReps("ROL2");
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public DB1 getDB1() {
        return this.getTyped("DB1", DB1.class);
    }

    public DB1 getDB1(int rep) {
        return this.getTyped("DB1", rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        return this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        return this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        return this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return this.getTyped("DRG", DRG.class);
    }

    public ADT_A01_PROCEDURE getPROCEDURE() {
        return this.getTyped("PROCEDURE", ADT_A01_PROCEDURE.class);
    }

    public ADT_A01_PROCEDURE getPROCEDURE(int rep) {
        return this.getTyped("PROCEDURE", rep, ADT_A01_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<ADT_A01_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", ADT_A01_PROCEDURE.class);
    }

    public void insertPROCEDURE(ADT_A01_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public ADT_A01_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (ADT_A01_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public ADT_A01_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (ADT_A01_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public GT1 getGT1() {
        return this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public ADT_A01_INSURANCE getINSURANCE() {
        return this.getTyped("INSURANCE", ADT_A01_INSURANCE.class);
    }

    public ADT_A01_INSURANCE getINSURANCE(int rep) {
        return this.getTyped("INSURANCE", rep, ADT_A01_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<ADT_A01_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ADT_A01_INSURANCE.class);
    }

    public void insertINSURANCE(ADT_A01_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public ADT_A01_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ADT_A01_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public ADT_A01_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ADT_A01_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        return this.getTyped("ACC", ACC.class);
    }

    public UB1 getUB1() {
        return this.getTyped("UB1", UB1.class);
    }

    public UB2 getUB2() {
        return this.getTyped("UB2", UB2.class);
    }

    public PDA getPDA() {
        return this.getTyped("PDA", PDA.class);
    }
}

