/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.OMI_O23_ORDER;
import ca.uhn.hl7v2.model.v251.group.OMI_O23_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMI_O23
extends AbstractMessage {
    public OMI_O23() {
        this(new DefaultModelClassFactory());
    }

    public OMI_O23(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, true);
            this.add(OMI_O23_PATIENT.class, false, false);
            this.add(OMI_O23_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OMI_O23 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMI_O23_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OMI_O23_PATIENT.class);
    }

    public OMI_O23_ORDER getORDER() {
        return this.getTyped("ORDER", OMI_O23_ORDER.class);
    }

    public OMI_O23_ORDER getORDER(int rep) {
        return this.getTyped("ORDER", rep, OMI_O23_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OMI_O23_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OMI_O23_ORDER.class);
    }

    public void insertORDER(OMI_O23_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public OMI_O23_ORDER insertORDER(int rep) throws HL7Exception {
        return (OMI_O23_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OMI_O23_ORDER removeORDER(int rep) throws HL7Exception {
        return (OMI_O23_ORDER)super.removeRepetition("ORDER", rep);
    }
}

