/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.OUL_R21_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.OUL_R21_PATIENT;
import ca.uhn.hl7v2.model.v251.group.OUL_R21_VISIT;
import ca.uhn.hl7v2.model.v251.segment.DSC;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUL_R21
extends AbstractMessage {
    public OUL_R21() {
        this(new DefaultModelClassFactory());
    }

    public OUL_R21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, false);
            this.add(OUL_R21_PATIENT.class, false, false);
            this.add(OUL_R21_VISIT.class, false, false);
            this.add(OUL_R21_ORDER_OBSERVATION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OUL_R21 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public OUL_R21_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OUL_R21_PATIENT.class);
    }

    public OUL_R21_VISIT getVISIT() {
        return this.getTyped("VISIT", OUL_R21_VISIT.class);
    }

    public OUL_R21_ORDER_OBSERVATION getORDER_OBSERVATION() {
        return this.getTyped("ORDER_OBSERVATION", OUL_R21_ORDER_OBSERVATION.class);
    }

    public OUL_R21_ORDER_OBSERVATION getORDER_OBSERVATION(int rep) {
        return this.getTyped("ORDER_OBSERVATION", rep, OUL_R21_ORDER_OBSERVATION.class);
    }

    public int getORDER_OBSERVATIONReps() {
        return this.getReps("ORDER_OBSERVATION");
    }

    public List<OUL_R21_ORDER_OBSERVATION> getORDER_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("ORDER_OBSERVATION", OUL_R21_ORDER_OBSERVATION.class);
    }

    public void insertORDER_OBSERVATION(OUL_R21_ORDER_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_OBSERVATION", structure, rep);
    }

    public OUL_R21_ORDER_OBSERVATION insertORDER_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_ORDER_OBSERVATION)super.insertRepetition("ORDER_OBSERVATION", rep);
    }

    public OUL_R21_ORDER_OBSERVATION removeORDER_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_ORDER_OBSERVATION)super.removeRepetition("ORDER_OBSERVATION", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

