/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EAC_U07_COMMAND;
import ca.uhn.hl7v2.model.v26.segment.EQU;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAC_U07
extends AbstractMessage {
    public EAC_U07() {
        this(new DefaultModelClassFactory());
    }

    public EAC_U07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EQU.class, true, false);
            this.add(EAC_U07_COMMAND.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating EAC_U07 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public EAC_U07_COMMAND getCOMMAND() {
        return this.getTyped("COMMAND", EAC_U07_COMMAND.class);
    }

    public EAC_U07_COMMAND getCOMMAND(int rep) {
        return this.getTyped("COMMAND", rep, EAC_U07_COMMAND.class);
    }

    public int getCOMMANDReps() {
        return this.getReps("COMMAND");
    }

    public List<EAC_U07_COMMAND> getCOMMANDAll() throws HL7Exception {
        return this.getAllAsList("COMMAND", EAC_U07_COMMAND.class);
    }

    public void insertCOMMAND(EAC_U07_COMMAND structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMAND", structure, rep);
    }

    public EAC_U07_COMMAND insertCOMMAND(int rep) throws HL7Exception {
        return (EAC_U07_COMMAND)super.insertRepetition("COMMAND", rep);
    }

    public EAC_U07_COMMAND removeCOMMAND(int rep) throws HL7Exception {
        return (EAC_U07_COMMAND)super.removeRepetition("COMMAND", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

