/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.util.EncodedMessageComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;

public class ParseTester {
    private static GenericParser parser = new GenericParser();
    private BufferedReader source;
    private String context;

    public static HL7Exception parsesCorrectly(String context, String message) {
        HL7Exception problem = null;
        try {
            Message m = parser.parse(message);
            String encoding = parser.getEncoding(message);
            String result = parser.encode(m, encoding);
            if (!EncodedMessageComparator.equivalent(message, result)) {
                problem = new HL7Exception(context + ": Original differs semantically from parsed/encoded message.\r\n-----Original:------------\r\n" + message + " \r\n------ Parsed/Encoded: ----------\r\n" + result + " \r\n-----Original Standardized: ---------\r\n" + EncodedMessageComparator.standardize(message) + " \r\n---------------------\r\n");
            }
        }
        catch (Exception e) {
            problem = new HL7Exception(context + ": " + e.getMessage() + " in message: \r\n-------------\r\n" + message + "\r\n-------------");
        }
        return problem;
    }

    public void setSource(Reader source) {
        this.source = new BufferedReader(new CommentFilterReader(source));
    }

    public void setContext(String description) {
        this.context = description;
    }

    public HL7Exception[] testAll(File source) throws IOException {
        ArrayList<HL7Exception> list = new ArrayList<HL7Exception>();
        System.out.println("Testing " + source.getPath());
        if (source.isDirectory()) {
            File[] contents = source.listFiles();
            for (int i = 0; i < contents.length; ++i) {
                HL7Exception[] exceptions = this.testAll(contents[i]);
                list.addAll(Arrays.asList(exceptions));
            }
        } else if (source.isFile()) {
            FileReader in = new FileReader(source);
            this.setSource(in);
            this.setContext(source.getAbsolutePath());
            HL7Exception[] exceptions = this.testAll();
            list.addAll(Arrays.asList(exceptions));
        } else {
            System.out.println("Warning: " + source.getPath() + " is not a normal file");
        }
        return list.toArray(new HL7Exception[0]);
    }

    public HL7Exception[] testAll() throws IOException {
        ArrayList<HL7Exception> list = new ArrayList<HL7Exception>();
        String message = null;
        while ((message = this.getNextMessage()).length() > 0) {
            HL7Exception e = ParseTester.parsesCorrectly(this.context, message);
            if (e == null) continue;
            list.add(e);
        }
        return list.toArray(new HL7Exception[0]);
    }

    public String getNextMessage() throws IOException {
        if (this.source == null) {
            throw new IOException("Message source is null -- call setSource() first");
        }
        StringBuffer message = new StringBuffer();
        boolean started = false;
        boolean finished = false;
        while (!finished) {
            String line = this.source.readLine();
            if (line == null || started && line.trim().length() == 0) {
                finished = true;
                continue;
            }
            if (line.trim().length() <= 0) continue;
            started = true;
            message.append(line);
            message.append("\r");
        }
        if (message.toString().trim().length() == 0) {
            return "";
        }
        return message.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1 || args[0].equalsIgnoreCase("-?") || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help")) {
            System.out.println("USAGE:");
            System.out.println("  ParseTester <source>");
            System.out.println();
            System.out.println("  <source> must be either a file containing HL7 messages or a directory containing such files");
            System.out.println();
            System.out.println("Notes:");
            System.out.println(" - Messages can be XML or ER7 encoded. ");
            System.out.println(" - If there are multiple messages in a file they must be delimited by blank lines");
            System.out.println(" - C and C++ style comments are skipped");
        } else {
            try {
                System.out.println("Testing ... ");
                File source = new File(args[0]);
                ParseTester tester = new ParseTester();
                HL7Exception[] exceptions = tester.testAll(source);
                if (exceptions.length > 0) {
                    System.out.println("Parsing problems with tested messages: ");
                }
                for (int i = 0; i < exceptions.length; ++i) {
                    System.out.println("PROBLEM #" + (i + 1));
                    System.out.println(exceptions[i].getMessage());
                }
            }
            catch (IOException e) {
                System.out.println("Testing failed to complete because of a problem reading source file(s) ... \r\n");
                e.printStackTrace();
            }
        }
    }

    public static class CommentFilterReader
    extends PushbackReader {
        private final char[] startCPPComment = new char[]{'/', '*'};
        private final char[] endCPPComment = new char[]{'*', '/'};
        private final char[] startCComment = new char[]{'/', '/'};
        private final char[] endCComment = new char[]{'\n'};
        private final char[] protocolDelim = new char[]{':', '/', '/'};

        public CommentFilterReader(Reader in) {
            super(in, 5);
        }

        public int read() throws IOException {
            block4: {
                block5: {
                    if (this.atSequence(this.protocolDelim)) break block4;
                    if (!this.atSequence(this.startCPPComment)) break block5;
                    while (!this.atSequence(this.endCPPComment)) {
                        super.read();
                    }
                    for (int i = 0; i < this.endCPPComment.length; ++i) {
                        super.read();
                    }
                    break block4;
                }
                if (!this.atSequence(this.startCComment)) break block4;
                while (!this.atSequence(this.endCComment)) {
                    super.read();
                }
                for (int i = 0; i < this.endCComment.length; ++i) {
                    super.read();
                }
            }
            return super.read();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = -1;
            boolean done = false;
            while (++i < len) {
                int next = this.read();
                if (next == 65535 || next == -1) {
                    done = true;
                    break;
                }
                cbuf[off + i] = (char)next;
            }
            if (i == 0 && done) {
                i = -1;
            }
            return i;
        }

        private boolean atSequence(char[] sequence) throws IOException {
            boolean result = true;
            int i = -1;
            int[] data = new int[sequence.length];
            while (++i < sequence.length && result) {
                data[i] = super.read();
                if ((char)data[i] == sequence[i]) continue;
                result = false;
            }
            for (int j = i - 1; j >= 0; --j) {
                this.unread(data[j]);
            }
            return result;
        }
    }
}

