/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.bean.BeanLogger;
import org.switchyard.component.bean.BeanMessages;
import org.switchyard.component.bean.BeanServiceMetadata;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.Invocation;
import org.switchyard.component.bean.Property;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.internal.ReferenceInvokerBean;
import org.switchyard.component.bean.internal.context.ContextProxy;
import org.switchyard.component.bean.internal.exchange.ExchangeProxy;
import org.switchyard.component.bean.internal.message.MessageProxy;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.ServiceHandler;

public class ServiceProxyHandler
extends BaseServiceHandler
implements ServiceHandler {
    private static Logger _logger = Logger.getLogger(ServiceProxyHandler.class);
    private Object _serviceBean;
    private BeanServiceMetadata _serviceMetadata;
    private BeanDeploymentMetaData _beanDeploymentMetaData;
    private Map<String, ServiceReference> _references = new HashMap<String, ServiceReference>();

    public ServiceProxyHandler(Object serviceBean, BeanServiceMetadata serviceMetadata, BeanDeploymentMetaData beanDeploymentMetaData) {
        this._serviceBean = serviceBean;
        this._serviceMetadata = serviceMetadata;
        this._beanDeploymentMetaData = beanDeploymentMetaData;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        this.handle(exchange);
    }

    public void handleFault(Exchange exchange) {
    }

    public void addReference(ServiceReference reference) {
        QName refName = ComponentNames.unqualify((ServiceReference)reference);
        this._references.put(refName.getLocalPart(), reference);
    }

    public void injectImplementationProperties(PropertyResolver resolver) {
        for (Field field : this._serviceBean.getClass().getDeclaredFields()) {
            Object property;
            Property propAnno = field.getAnnotation(Property.class);
            if (propAnno == null) continue;
            String propertyName = propAnno.name();
            if (propertyName.equals("")) {
                propertyName = field.getName();
            }
            if ((property = resolver.resolveProperty(propertyName)) == null) continue;
            if (field.getType().isAssignableFrom(property.getClass())) {
                new FieldAccess(field).write(this._serviceBean, property);
                continue;
            }
            BeanLogger.ROOT_LOGGER.propertyHasIncompatibleTypeBean(propAnno.name(), this._serviceMetadata.getServiceClass().getName(), field.getType().getName(), property.getClass().getName());
        }
    }

    protected ClassLoader getDeploymentClassLoader() {
        return this._beanDeploymentMetaData.getDeploymentClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle(Exchange exchange) throws HandlerException {
        Invocation invocation = this._serviceMetadata.getInvocation(exchange);
        if (invocation == null) throw BeanMessages.MESSAGES.unexpectedErrorBeanServiceMetadataShouldReturnAnInvocationInstanceOrThrowABeanComponentException();
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        try {
            Object responseObject;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("CDI Bean Service ExchangeHandler proxy class received " + exchangePattern + " Exchange (" + System.identityHashCode(exchange) + ") for Bean Service '" + exchange.getProvider().getName() + "'.  Invoking bean method '" + invocation.getMethod().getName() + "'."));
            }
            ContextProxy.setContext(exchange.getContext());
            MessageProxy.setMessage(exchange.getMessage());
            ExchangeProxy.setExchange(exchange);
            try {
                responseObject = invocation.getMethod().invoke(this._serviceBean, invocation.getArgs());
            }
            finally {
                ContextProxy.setContext(null);
                MessageProxy.setMessage(null);
                ExchangeProxy.setExchange(null);
            }
            if (exchangePattern != ExchangePattern.IN_OUT || exchange.getPhase() == ExchangePhase.OUT) return;
            Message message = exchange.createMessage();
            message.setContent(responseObject);
            exchange.send(message);
            return;
        }
        catch (Exception ex) {
            Throwable faultContent;
            String errMsg = BeanMessages.MESSAGES.invocationOfOperationFailed(invocation.getMethod().getName(), this._serviceBean.getClass().getName());
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)errMsg, (Throwable)ex);
            }
            if ((faultContent = ex) instanceof InvocationTargetException) {
                faultContent = ((InvocationTargetException)ex).getTargetException();
            }
            if (exchangePattern != ExchangePattern.IN_OUT) throw new HandlerException(faultContent);
            for (Class<?> expectedFault : invocation.getMethod().getExceptionTypes()) {
                if (!expectedFault.isAssignableFrom(faultContent.getClass())) continue;
                exchange.sendFault(exchange.createMessage().setContent((Object)faultContent));
                return;
            }
            throw new HandlerException(faultContent);
        }
    }

    protected void doStart() {
        for (ClientProxyBean proxyBean : this._beanDeploymentMetaData.getClientProxies()) {
            if (!this._references.containsKey(proxyBean.getServiceName())) continue;
            proxyBean.setService(this._references.get(proxyBean.getServiceName()));
        }
        for (ReferenceInvokerBean invokerBean : this._beanDeploymentMetaData.getReferenceInvokers()) {
            if (!this._references.containsKey(invokerBean.getServiceName())) continue;
            invokerBean.setReference(this._references.get(invokerBean.getServiceName()));
        }
    }

    public void stop() {
    }
}

