/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.bpm.console.client.model.TokenReference;

@XmlRootElement(name="processInstance")
public class ProcessInstanceRef {
    private String id;
    private String definitionId;
    private String key;
    private Date startDate;
    private Date endDate;
    private boolean suspended;
    private RESULT endResult;
    private transient Lifecycle lifecycle;
    private TokenReference rootToken;

    public ProcessInstanceRef() {
        this.initLifecycle();
    }

    public ProcessInstanceRef(String id, String processDefinitionId, Date startDate, Date endDate, boolean suspended) {
        if (null == startDate) {
            throw new IllegalArgumentException("An instance requires a start date");
        }
        if (endDate != null && suspended) {
            throw new IllegalArgumentException("An instance cannot be ended and suspended at the same time");
        }
        this.id = id;
        this.definitionId = processDefinitionId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.suspended = suspended;
        this.initLifecycle();
    }

    private void initLifecycle() {
        this.lifecycle = this.hasEnded() ? new Lifecycle(this, STATE.ENDED) : (this.isSuspended() ? new Lifecycle(this, STATE.SUSPENDED) : new Lifecycle(this, STATE.RUNNING));
    }

    @XmlElement(name="instanceId")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="definitionId")
    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    @XmlElement(name="key")
    public String getKey() {
        return this.key != null ? this.key : "";
    }

    public void setKey(String key) {
        this.key = key;
    }

    @XmlElement(name="status")
    public STATE getState() {
        return this.lifecycle.getState();
    }

    public void setState(String nextState) {
        this.setState(STATE.valueOf(nextState));
    }

    public void setState(STATE nextState) {
        this.lifecycle = this.lifecycle.transitionTo(nextState);
    }

    @XmlElement(name="start")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @XmlElement(name="end")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isRunning() {
        return this.startDate != null && !this.isSuspended();
    }

    public boolean hasEnded() {
        return this.startDate != null && this.endDate != null;
    }

    public boolean isSuspended() {
        return null == this.endDate && this.suspended;
    }

    public TokenReference getRootToken() {
        return this.rootToken;
    }

    public void setRootToken(TokenReference rootToken) {
        this.rootToken = rootToken;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
        this.initLifecycle();
    }

    public RESULT getEndResult() {
        return this.endResult;
    }

    public void setEndResult(RESULT endResult) {
        if (this.getState() != STATE.ENDED) {
            throw new IllegalArgumentException("Cannot set end result in state " + (Object)((Object)this.getState()));
        }
        this.endResult = endResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceRef that = (ProcessInstanceRef)o;
        if (this.definitionId != null ? !this.definitionId.equals(that.definitionId) : that.definitionId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.definitionId != null ? this.definitionId.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }

    private class IllegalTransitionException
    extends IllegalArgumentException {
        public IllegalTransitionException(STATE current, STATE next) {
            super("Illegal transition current " + (Object)((Object)current) + " next " + (Object)((Object)next));
        }
    }

    private class Lifecycle {
        private STATE current;
        private ProcessInstanceRef instance;

        public Lifecycle(ProcessInstanceRef instance, STATE current) {
            this.instance = instance;
            this.current = current;
        }

        public Lifecycle transitionTo(STATE next) {
            Lifecycle nextLifecycle = null;
            switch (next) {
                case SUSPENDED: {
                    if (STATE.RUNNING.equals((Object)this.current)) {
                        nextLifecycle = new Lifecycle(this.instance, next);
                        this.instance.suspended = true;
                        break;
                    }
                    throw new IllegalTransitionException(this.current, next);
                }
                case ENDED: {
                    if (STATE.RUNNING.equals((Object)this.current) || STATE.SUSPENDED.equals((Object)this.current)) {
                        nextLifecycle = new Lifecycle(this.instance, next);
                        this.instance.suspended = false;
                        this.instance.endDate = new Date();
                        break;
                    }
                    throw new IllegalTransitionException(this.current, next);
                }
                case RUNNING: {
                    if (STATE.SUSPENDED.equals((Object)this.current)) {
                        nextLifecycle = new Lifecycle(this.instance, next);
                        this.instance.suspended = false;
                        break;
                    }
                    throw new IllegalTransitionException(this.current, next);
                }
                default: {
                    throw new IllegalTransitionException(this.current, next);
                }
            }
            return nextLifecycle;
        }

        public STATE getState() {
            return this.current;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Lifecycle lifecycle = (Lifecycle)o;
            return this.current == lifecycle.current;
        }

        public int hashCode() {
            int result = this.current != null ? this.current.hashCode() : 0;
            return result;
        }
    }

    public static enum RESULT {
        COMPLETED,
        FAILED,
        ERROR,
        EXITED,
        OBSOLETE;

    }

    public static enum STATE {
        RUNNING,
        SUSPENDED,
        ENDED;

    }
}

