/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.ws;

import java.net.URL;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;
import org.jboss.wsf.spi.publish.EndpointPublisherFactory;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.switchyard.ServiceDomain;
import org.switchyard.as7.extension.ws.Interceptors;
import org.switchyard.as7.extension.ws.SwitchYardSecurityDomainContext;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.EndpointConfigModel;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.BaseWebService;

public class JBossWSEndpoint
implements org.switchyard.component.common.Endpoint {
    private static final Logger LOGGER = Logger.getLogger((String)"org.switchyard");
    private static final String HOST = "default-host";
    private static final EndpointPublisherFactory FACTORY;
    private EndpointPublisher _publisher;
    private Context _context;

    public JBossWSEndpoint() throws Exception {
        this._publisher = FACTORY.newEndpointPublisher(HOST);
    }

    public JBossWSEndpoint(String host) throws Exception {
        this._publisher = FACTORY.newEndpointPublisher(host);
    }

    public void publish(ServiceDomain domain, String contextRoot, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData wsMetadata, SOAPBindingModel bindingModel, InboundHandler handler) throws Exception {
        EndpointConfigModel epcModel = bindingModel.getEndpointConfig();
        JBossWebservicesMetaData jbwsMetadata = null;
        if (epcModel != null) {
            String configName = epcModel.getConfigName();
            String configFile = epcModel.getConfigFile();
            if (configFile != null) {
                URL jbwsURL = Classes.getResource((String)configFile, this.getClass());
                try {
                    JBossWebservicesFactory factory = new JBossWebservicesFactory(jbwsURL);
                    jbwsMetadata = factory.load(jbwsURL);
                }
                catch (WebServiceException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error((Object)"Unable to load jboss-webservices metadata", (Throwable)e);
                    }
                    jbwsMetadata = new JBossWebservicesMetaData("/", configName, configFile, jbwsURL, null, null, null);
                }
            }
        }
        ClassLoader tccl = Classes.getTCCL();
        this._context = this._publisher.publish(contextRoot, tccl, urlPatternToClassNameMap, wsMetadata, jbwsMetadata);
        for (Endpoint ep : this._context.getEndpoints()) {
            BaseWebService wsProvider = (BaseWebService)ep.getInstanceProvider().getInstance(BaseWebService.class.getName()).getValue();
            wsProvider.setInvocationClassLoader(tccl);
            wsProvider.setConsumer(handler);
            Interceptors.addInterceptors(ep, bindingModel, tccl);
            ep.setSecurityDomainContext((SecurityDomainContext)new SwitchYardSecurityDomainContext(domain.getServiceSecurity(bindingModel.getService().getComponentService().getSecurity()).getSecurityDomain(), ep.getSecurityDomainContext()));
        }
    }

    public void start() {
    }

    public void stop() {
        if (this._context != null && this._publisher != null) {
            try {
                this._publisher.destroy(this._context);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }

    static {
        try {
            ClassLoader loader = ClassLoaderProvider.getDefaultProvider().getWebServiceSubsystemClassLoader();
            FACTORY = ServiceLoader.load(EndpointPublisherFactory.class, loader).iterator().next();
        }
        catch (Exception e) {
            throw new WebServicePublishException((Throwable)e);
        }
    }
}

