/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.context;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.security.auth.Subject;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.principal.UserPrincipal;
import org.switchyard.security.system.SystemSecurity;

public final class DefaultSecurityContext
implements SecurityContext {
    private static final long serialVersionUID = -5672423874298035845L;
    private static final String FORMAT = DefaultSecurityContext.class.getSimpleName() + "@%s[systemUUID=%s, expirationMillis=%s, credentials=%s, securityDomainsToSubjects=%s]";
    private final UUID _systemUUID;
    private final long _expirationMillis;
    private final Set<Credential> _credentials = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<String, Subject> _securityDomainsToSubjects = Collections.synchronizedMap(new TreeMap());

    DefaultSecurityContext() {
        this(null, null);
    }

    DefaultSecurityContext(UUID systemUUID, Long timeoutMillis) {
        long tm;
        this._systemUUID = systemUUID != null ? systemUUID : SystemSecurity.DEFAULT.getUUID();
        long em = 0L;
        if (timeoutMillis != null && (tm = timeoutMillis.longValue()) > 0L) {
            em = System.currentTimeMillis() + tm;
        }
        this._expirationMillis = em;
    }

    @Override
    public boolean isValid(UUID systemUUID) {
        return this._systemUUID.equals(systemUUID) && (this._expirationMillis == 0L || this._expirationMillis > System.currentTimeMillis());
    }

    @Override
    public Set<Credential> getCredentials() {
        return this._credentials;
    }

    @Override
    public <T extends Credential> Set<T> getCredentials(Class<T> clazz) {
        HashSet<T> matches = new HashSet<T>();
        for (Credential credential : this.getCredentials()) {
            if (credential == null || !clazz.isAssignableFrom(credential.getClass())) continue;
            matches.add(clazz.cast(credential));
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearCredentials() {
        Set<Credential> set = this._credentials;
        synchronized (set) {
            this._credentials.clear();
        }
    }

    @Override
    public Subject getSubject(String securityDomain) {
        return this.getSubject(securityDomain, true);
    }

    @Override
    public synchronized Subject getSubject(String securityDomain, boolean create) {
        Subject subject = this._securityDomainsToSubjects.get(securityDomain);
        if (subject == null && create) {
            subject = new Subject();
            this._securityDomainsToSubjects.put(securityDomain, subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearSubject(String securityDomain) {
        Map<String, Subject> map = this._securityDomainsToSubjects;
        synchronized (map) {
            this._securityDomainsToSubjects.remove(securityDomain);
        }
    }

    @Override
    public Principal getCallerPrincipal(String securityDomain) {
        Principal callerPrincipal = null;
        Subject subject = this.getSubject(securityDomain, false);
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (principal instanceof Group) {
                    Enumeration members;
                    Group group = (Group)principal;
                    if (!group.getName().equalsIgnoreCase("CallerPrincipal") || !(members = group.members()).hasMoreElements()) continue;
                    callerPrincipal = (Principal)members.nextElement();
                    break;
                }
                if (callerPrincipal != null || principal == null || !(principal instanceof UserPrincipal) && !principal.getClass().getSimpleName().equals("UserPrincipal")) continue;
                callerPrincipal = principal;
            }
        }
        return callerPrincipal;
    }

    @Override
    public boolean isCallerInRole(String roleName, String securityDomain) {
        Subject subject = this.getSubject(securityDomain, false);
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                Group group;
                if (!(principal instanceof Group) || !(group = (Group)principal).getName().equalsIgnoreCase("Roles")) continue;
                Enumeration roles = group.members();
                while (roles.hasMoreElements()) {
                    Principal role = (Principal)roles.nextElement();
                    if (!role.getName().equals(roleName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._systemUUID, this._expirationMillis, this._credentials, this._securityDomainsToSubjects);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._systemUUID == null ? 0 : this._systemUUID.hashCode());
        result = 31 * result + (this._credentials == null ? 0 : this._credentials.hashCode());
        result = 31 * result + (this._securityDomainsToSubjects == null ? 0 : this._securityDomainsToSubjects.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSecurityContext other = (DefaultSecurityContext)obj;
        if (this._systemUUID == null ? other._systemUUID != null : !this._systemUUID.equals(other._systemUUID)) {
            return false;
        }
        if (this._credentials == null ? other._credentials != null : !this._credentials.equals(other._credentials)) {
            return false;
        }
        return !(this._securityDomainsToSubjects == null ? other._securityDomainsToSubjects != null : !this._securityDomainsToSubjects.equals(other._securityDomainsToSubjects));
    }
}

