/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.util.Types;
import org.switchyard.common.type.Classes;

public final class RESTEasyUtil {
    private static final Logger LOGGER = Logger.getLogger(RESTEasyUtil.class);
    private static final String CLIENT_ERROR_INTERCEPTORS = "resteasy.client.error.interceptors";

    private RESTEasyUtil() {
    }

    public static List<String> getParamValues(Map<String, String> contextParams, String paramName) {
        String providers;
        if (contextParams != null && (providers = contextParams.get(paramName)) != null) {
            return Arrays.asList(providers.split(","));
        }
        return null;
    }

    public static List<Class<?>> getProviderClasses(Map<String, String> contextParams) {
        List<String> providers = RESTEasyUtil.getParamValues(contextParams, "resteasy.providers");
        if (providers != null) {
            ArrayList providerClasses = new ArrayList(providers.size());
            for (String provider : providers) {
                Class pc = Classes.forName((String)provider.trim());
                if (pc == null) continue;
                providerClasses.add(pc);
            }
            return providerClasses.isEmpty() ? null : providerClasses;
        }
        return null;
    }

    public static Map<Class<?>, Class<?>> getExceptionProviderMap(Map<String, String> contextParams) {
        HashMap providerMap = new HashMap();
        List<String> providers = RESTEasyUtil.getParamValues(contextParams, "resteasy.providers");
        if (providers != null) {
            for (String provider : providers) {
                Class providerClass = Classes.forName((String)provider.trim());
                if (providerClass == null) continue;
                Type exceptionType = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, ExceptionMapper.class)[0];
                Class exceptionClass = Types.getRawType((Type)exceptionType);
                providerMap.put(exceptionClass, providerClass);
            }
        }
        return providerMap;
    }

    public static List<ClientErrorInterceptor> getClientErrorInterceptors(Map<String, String> contextParams) {
        ArrayList<ClientErrorInterceptor> interceptorInstances = null;
        List<String> interceptors = RESTEasyUtil.getParamValues(contextParams, CLIENT_ERROR_INTERCEPTORS);
        if (interceptors != null) {
            interceptorInstances = new ArrayList<ClientErrorInterceptor>(interceptors.size());
            for (String interceptor : interceptors) {
                Class ic = Classes.forName((String)interceptor.trim());
                if (ic == null) continue;
                try {
                    ClientErrorInterceptor instance = (ClientErrorInterceptor)ic.newInstance();
                    interceptorInstances.add(instance);
                }
                catch (InstantiationException ie) {
                    LOGGER.warn((Object)ie);
                }
                catch (IllegalAccessException iae) {
                    LOGGER.warn((Object)iae);
                }
            }
        }
        return interceptorInstances;
    }
}

