/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.jboss.jbossts.txbridge.inbound.InboundBridge;
import org.jboss.jbossts.txbridge.inbound.InboundBridgeManager;
import org.jboss.logging.Logger;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SCALogger;
import org.switchyard.component.sca.SCAMessages;
import org.switchyard.component.sca.TransactionContextSerializer;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public class SwitchYardRemotingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger _log = Logger.getLogger(SwitchYardRemotingServlet.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private TransactionContextSerializer _txSerializer = new TransactionContextSerializer();
    private RemoteEndpointPublisher _endpointPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader setTCCL = null;
        boolean transactionPropagated = false;
        try {
            ServiceDomain domain = this.findDomain(request);
            ClassLoader loader = (ClassLoader)domain.getProperty("org.switchyard.deployment.DeploymentClassLoader");
            setTCCL = Classes.setTCCL((ClassLoader)loader);
            transactionPropagated = this.bridgeIncomingTransaction(request);
            RemoteMessage msg = (RemoteMessage)this._serializer.deserialize((InputStream)request.getInputStream(), RemoteMessage.class);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Remote servlet received request for service " + msg.getService()));
            }
            ServiceReference service = domain.getServiceReference(msg.getService());
            SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
            Exchange ex = msg.getOperation() == null ? service.createExchange((ExchangeHandler)replyHandler) : service.createExchange(msg.getOperation(), (ExchangeHandler)replyHandler);
            Message m = ex.createMessage();
            if (msg.getContext() != null) {
                m.getContext().setProperties(msg.getContext().getProperties());
            }
            m.setContent(msg.getContent());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoking service " + msg.getService()));
            }
            ex.send(m);
            RemoteMessage reply = null;
            if (ExchangePattern.IN_OUT.equals((Object)ex.getPattern())) {
                replyHandler.waitForOut();
                reply = this.createReplyMessage(ex);
            } else if (ExchangeState.FAULT.equals((Object)ex.getState())) {
                reply = this.createReplyMessage(ex);
            }
            if (transactionPropagated) {
                this.bridgeOutgoingTransaction();
                transactionPropagated = false;
            }
            if (reply != null) {
                ServletOutputStream out = response.getOutputStream();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Writing reply message to HTTP response stream " + msg.getService()));
                }
                this._serializer.serialize((Object)reply, RemoteMessage.class, (OutputStream)out);
                out.flush();
            } else {
                response.setStatus(204);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No content to return for invocation of " + msg.getService()));
                }
            }
            if (transactionPropagated) {
                this.bridgeOutgoingTransaction();
            }
            if (setTCCL == null) return;
        }
        catch (SwitchYardException syEx) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Failed to process remote invocation", (Throwable)syEx);
                }
                RemoteMessage reply = new RemoteMessage();
                reply.setFault(true);
                reply.setContent((Object)syEx);
                this._serializer.serialize((Object)reply, RemoteMessage.class, (OutputStream)response.getOutputStream());
                response.getOutputStream().flush();
                if (transactionPropagated) {
                    this.bridgeOutgoingTransaction();
                }
                if (setTCCL == null) return;
            }
            catch (Throwable throwable) {
                if (transactionPropagated) {
                    this.bridgeOutgoingTransaction();
                }
                if (setTCCL == null) throw throwable;
                Classes.setTCCL(setTCCL);
                throw throwable;
            }
            Classes.setTCCL((ClassLoader)setTCCL);
            return;
        }
        Classes.setTCCL((ClassLoader)setTCCL);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bridgeIncomingTransaction(HttpServletRequest request) {
        try {
            String txContextHeader = request.getHeader("switchyard-transaction-context");
            if (txContextHeader == null) {
                return false;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Transaction context is found in request message: " + txContextHeader));
            }
            if (this._endpointPublisher.isDisableRemoteTransaction()) {
                SCALogger.ROOT_LOGGER.ignoringReceivedTransactionContext();
                return false;
            }
            ClassLoader origCl = Thread.currentThread().getContextClassLoader();
            CoordinationContextType cc = null;
            try {
                Thread.currentThread().setContextClassLoader(SwitchYardRemotingServlet.class.getClassLoader());
                cc = this._txSerializer.deserialise(txContextHeader);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origCl);
            }
            TxContextImple txContext = new TxContextImple(cc);
            TransactionManagerFactory.transactionManager().resume((TxContext)txContext);
            InboundBridge txInboundBridge = InboundBridgeManager.getInboundBridge();
            txInboundBridge.start();
            return true;
        }
        catch (Throwable t) {
            throw new SwitchYardException(t);
        }
    }

    private void bridgeOutgoingTransaction() {
        try {
            InboundBridge txInboundBridge = InboundBridgeManager.getInboundBridge();
            txInboundBridge.stop();
            TransactionManager wsatManager = TransactionManagerFactory.transactionManager();
            if (wsatManager != null) {
                wsatManager.suspend();
            }
        }
        catch (Throwable th) {
            throw new SwitchYardException(th);
        }
    }

    private ServiceDomain findDomain(HttpServletRequest request) throws SwitchYardException {
        ServiceDomain domain = null;
        String service = request.getHeader("switchyard-service");
        if (service == null || service.trim().length() == 0) {
            throw SCAMessages.MESSAGES.requiredHeaderIsMissingOrEmpty("switchyard-service");
        }
        domain = this._endpointPublisher.getDomain(QName.valueOf(service));
        if (domain == null) {
            throw SCAMessages.MESSAGES.unableToFindServiceDomainForService(service);
        }
        return domain;
    }

    public void setEndpointPublisher(RemoteEndpointPublisher endpointPublisher) {
        this._endpointPublisher = endpointPublisher;
    }

    RemoteMessage createReplyMessage(Exchange exchange) {
        RemoteMessage reply = new RemoteMessage();
        reply.setDomain(exchange.getProvider().getDomain().getName()).setOperation(exchange.getContract().getConsumerOperation().getName()).setService(exchange.getConsumer().getName());
        exchange.getContext().mergeInto(reply.getContext());
        if (exchange.getMessage() != null) {
            reply.setContent(exchange.getMessage().getContent());
        }
        if (exchange.getState().equals((Object)ExchangeState.FAULT)) {
            reply.setFault(true);
        }
        return reply;
    }
}

