/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import org.jboss.resteasy.spi.Registry;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.switchyard.component.resteasy.osgi.OsgiRESTEasyServletWrapper;

public class OsgiRESTEasyServletRegistry {
    private final ConcurrentHashMap<String, OsgiRESTEasyServletWrapper> _servlets = new ConcurrentHashMap();
    private HttpService _httpService;

    public OsgiRESTEasyServletRegistry setOsgiHttpService(HttpService service) {
        this._httpService = service;
        return this;
    }

    public void registerRESTEasyServlet(String alias, OsgiRESTEasyServletWrapper servlet, Dictionary<?, ?> initparams, HttpContext context) throws Exception {
        this._httpService.registerServlet(alias, (Servlet)servlet, initparams, context);
        this._servlets.put(alias, servlet);
    }

    public OsgiRESTEasyServletWrapper getRegisteredRESTEasyServlet(String alias) {
        return this._servlets.get(alias);
    }

    public void unregisterRESTEasyServlet(String alias) {
        OsgiRESTEasyServletWrapper servlet = this.getRegisteredRESTEasyServlet(alias);
        if (servlet == null) {
            throw new IllegalArgumentException("No RESTEasy servlet is registered for the alias '" + alias + "'");
        }
        if (servlet.getDispatcher().getRegistry().getSize() != 0) {
            throw new IllegalStateException("Cannot remove RESTEasy Servlet '" + alias + "' - registry is not empty");
        }
        this._httpService.unregister(alias);
        this._servlets.remove(alias);
    }

    public List<Class<?>> registerRESTEasyResources(String alias, List<Object> resources) {
        OsgiRESTEasyServletWrapper servlet = this.getRegisteredRESTEasyServlet(alias);
        if (servlet == null) {
            throw new IllegalArgumentException("No servlet is registered for the alias '" + alias + "'");
        }
        Registry registry = servlet.getDispatcher().getRegistry();
        ArrayList classes = new ArrayList();
        for (Object instance : resources) {
            registry.addSingletonResource(instance);
            classes.add(instance.getClass());
        }
        return classes;
    }

    public void unregisterRESTEasyResources(String alias, List<Class<?>> resourceClasses) {
        OsgiRESTEasyServletWrapper servlet = this.getRegisteredRESTEasyServlet(alias);
        if (servlet == null) {
            throw new IllegalArgumentException("No servlet is registered for the alias '" + alias + "'");
        }
        Registry registry = servlet.getDispatcher().getRegistry();
        for (Class<?> clazz : resourceClasses) {
            registry.removeRegistrations(clazz);
        }
    }
}

