/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extractor;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.switchyard.security.credential.CertificateCredential;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.credential.extractor.AuthorizationHeaderCredentialExtractor;
import org.switchyard.security.credential.extractor.ServletRequestCredentialExtractor;
import org.switchyard.security.principal.UserPrincipal;

public class DefaultServletRequestCredentialExtractor
implements ServletRequestCredentialExtractor {
    @Override
    public Set<Credential> extract(ServletRequest source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (source != null) {
            if (source.isSecure()) {
                credentials.add(new ConfidentialityCredential(true));
            }
            if (source instanceof HttpServletRequest) {
                String charsetName;
                String remoteUser;
                HttpServletRequest request = (HttpServletRequest)source;
                Principal userPrincipal = request.getUserPrincipal();
                if (userPrincipal != null) {
                    credentials.add(new PrincipalCredential(userPrincipal, true));
                }
                if ((remoteUser = request.getRemoteUser()) != null) {
                    credentials.add(new PrincipalCredential(new UserPrincipal(remoteUser), true));
                }
                AuthorizationHeaderCredentialExtractor ahce = (charsetName = source.getCharacterEncoding()) != null ? new AuthorizationHeaderCredentialExtractor(charsetName) : new AuthorizationHeaderCredentialExtractor();
                credentials.addAll(ahce.extract(request.getHeader("Authorization")));
                X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                if (certs != null) {
                    credentials.add(new CertificateCredential(certs[0]));
                }
            }
        }
        return credentials;
    }
}

