/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import javax.naming.InitialContext;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.MessageListener;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.SwitchYardException;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.composer.MappedRecordBindingData;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.selector.OperationSelector;

public class CCIEndpoint
extends AbstractInflowEndpoint
implements MessageListener {
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String DEFAULT_RECORD_NAME = "DefaultMappedRecord";
    private static final String DEFAULT_DESCRIPTION = "Default MappedRecord implementation by " + CCIEndpoint.class.getName();
    private String _connectionFactoryJNDIName;
    private long _waitTimeout = 15000L;
    private String _recordName = "DefaultMappedRecord";
    private String _description = DEFAULT_DESCRIPTION;
    private MessageComposer<MappedRecordBindingData> _composer;
    private OperationSelector<MappedRecordBindingData> _selector;
    private RecordFactory _recordFactory;

    @Override
    public void initialize() {
        super.initialize();
        this._composer = this.getMessageComposer(MappedRecordBindingData.class);
        this._selector = this.getOperationSelector(MappedRecordBindingData.class);
        try {
            ConnectionFactory factory = (ConnectionFactory)new InitialContext().lookup(this._connectionFactoryJNDIName);
            this._recordFactory = factory.getRecordFactory();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public Record onMessage(Record record) {
        SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
        MappedRecord sourceRecord = (MappedRecord)MappedRecord.class.cast(record);
        try {
            MappedRecordBindingData bindingData = new MappedRecordBindingData(sourceRecord);
            String operation = this._selector != null ? this._selector.selectOperation((Object)bindingData).getLocalPart() : null;
            Exchange exchange = this.createExchange(operation, (ExchangeHandler)inOutHandler);
            exchange.send(this._composer.compose((BindingData)bindingData, exchange));
            exchange = inOutHandler.waitForOut(this._waitTimeout);
            MappedRecord returnRecord = this._recordFactory.createMappedRecord(this._recordName);
            returnRecord.setRecordShortDescription(this._description);
            return ((MappedRecordBindingData)this._composer.decompose(exchange, (BindingData)new MappedRecordBindingData(returnRecord))).getRecord();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void setConnectionFactoryJNDIName(String name) {
        this._connectionFactoryJNDIName = name;
    }

    public String getConnectionFactoryJNDIName() {
        return this._connectionFactoryJNDIName;
    }
}

