/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.metric;

import java.util.Calendar;
import java.util.Date;
import org.jboss.bpm.monitor.model.metric.Timespan;

public class TimespanFactory {
    public static final String LAST_24_HOURS = "Last 24 Hours";
    public static final String LAST_DAY = "Last Day";
    public static final String LAST_7_DAYS = "Last 7 Days";
    public static final String LAST_WEEK = "Last Week";
    public static final String LAST_4_WEEKS = "Last 4 Weeks";
    public static final String LAST_MONTH = "Last Month";
    public static final String LAST_3_MONTH = "Last 3 Month";
    public static final String LAST_QUARTER = "Last Quarter";
    public static final String LAST_12_MONTH = "Last 12 Month";
    public static final String LAST_YEAR = "Last Year";

    public static Timespan last24Hours() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(6, -1);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.HOUR, LAST_24_HOURS);
    }

    public static Timespan lastDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -1);
        DayBounds dayBounds = new DayBounds(cal).invoke();
        long t0 = dayBounds.getT0();
        long t1 = dayBounds.getT1();
        return new Timespan(t0, t1, Timespan.UNIT.HOUR, LAST_DAY);
    }

    public static Timespan last7Days() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(6, -7);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.DAY, LAST_7_DAYS);
    }

    public static Timespan lastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(3, -1);
        WeekBounds weekBounds = new WeekBounds(cal).invoke();
        long t0 = weekBounds.getT0();
        long t1 = weekBounds.getT1();
        return new Timespan(t0, t1, Timespan.UNIT.DAY, LAST_WEEK);
    }

    public static Timespan last4Weeks() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(3, -4);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.DAY, LAST_4_WEEKS);
    }

    public static Timespan lastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        MonthBounds monthBounds = new MonthBounds(cal).invoke();
        long t0 = monthBounds.getT0();
        long t1 = monthBounds.getT1();
        return new Timespan(t0, t1, Timespan.UNIT.DAY, LAST_MONTH);
    }

    public static Timespan last3Month() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(2, -3);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.WEEK, LAST_3_MONTH);
    }

    public static Timespan lastQuarter() {
        Calendar cal = Calendar.getInstance();
        long currentMonth = cal.get(2);
        if (currentMonth >= 1L && currentMonth <= 3L) {
            cal.set(2, 2);
        } else if (currentMonth >= 4L && currentMonth <= 6L) {
            cal.set(2, 5);
        } else if (currentMonth >= 7L && currentMonth <= 9L) {
            cal.set(2, 8);
        } else {
            cal.set(2, 11);
        }
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.add(2, -2);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.WEEK, LAST_QUARTER);
    }

    public static Timespan last12Month() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(1, -1);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.MONTH, LAST_12_MONTH);
    }

    public static Timespan lastYear() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        cal.set(2, 11);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, Timespan.UNIT.MONTH, LAST_YEAR);
    }

    public static Timespan fromValue(String value) {
        Timespan t = null;
        if (LAST_24_HOURS.equals(value)) {
            t = TimespanFactory.last24Hours();
        } else if (LAST_DAY.equals(value)) {
            t = TimespanFactory.lastDay();
        } else if (LAST_7_DAYS.equals(value)) {
            t = TimespanFactory.last7Days();
        } else if (LAST_WEEK.equals(value)) {
            t = TimespanFactory.lastWeek();
        } else if (LAST_4_WEEKS.equals(value)) {
            t = TimespanFactory.last4Weeks();
        } else if (LAST_MONTH.equals(value)) {
            t = TimespanFactory.lastMonth();
        } else if (LAST_3_MONTH.equals(value)) {
            t = TimespanFactory.last3Month();
        } else if (LAST_QUARTER.equals(value)) {
            t = TimespanFactory.lastQuarter();
        } else if (LAST_12_MONTH.equals(value)) {
            t = TimespanFactory.last12Month();
        } else if (LAST_YEAR.equals(value)) {
            t = TimespanFactory.lastYear();
        }
        if (null == t) {
            throw new IllegalArgumentException("Unknown value: " + value);
        }
        return t;
    }

    public static long[] getLeftBounds(Timespan timespan, Date date) {
        long[] bounds = new long[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timespan.getUnit()) {
            case HOUR: {
                bounds[1] = cal.getTimeInMillis();
                cal.add(11, -1);
                bounds[0] = cal.getTimeInMillis();
                break;
            }
            case DAY: {
                bounds[1] = cal.getTimeInMillis();
                cal.add(6, -1);
                bounds[0] = cal.getTimeInMillis();
                break;
            }
            case WEEK: {
                bounds[1] = cal.getTimeInMillis();
                cal.add(3, -1);
                bounds[0] = cal.getTimeInMillis();
                break;
            }
            case MONTH: {
                bounds[1] = cal.getTimeInMillis();
                cal.add(2, -1);
                bounds[0] = cal.getTimeInMillis();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown unit " + (Object)((Object)timespan.getUnit()));
            }
        }
        return bounds;
    }

    private static class MonthBounds {
        private Calendar cal;
        private long t1;
        private long t0;

        public MonthBounds(Calendar cal) {
            this.cal = cal;
        }

        public long getT1() {
            return this.t1;
        }

        public long getT0() {
            return this.t0;
        }

        public MonthBounds invoke() {
            this.cal.set(5, this.cal.getActualMinimum(5));
            this.cal.set(11, this.cal.getActualMinimum(11));
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.t0 = this.cal.getTimeInMillis();
            this.cal.set(5, this.cal.getActualMaximum(5));
            this.cal.set(11, this.cal.getActualMaximum(11));
            this.cal.set(12, 59);
            this.cal.set(13, 59);
            this.t1 = this.cal.getTimeInMillis();
            return this;
        }
    }

    private static class WeekBounds {
        private long t1;
        private long t0;
        private Calendar cal;

        private WeekBounds(Calendar cal) {
            this.cal = cal;
        }

        public long getT1() {
            return this.t1;
        }

        public long getT0() {
            return this.t0;
        }

        public WeekBounds invoke() {
            this.cal.set(7, this.cal.getActualMinimum(7));
            this.cal.set(11, this.cal.getActualMinimum(11));
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.t0 = this.cal.getTimeInMillis();
            this.cal.set(7, this.cal.getActualMaximum(7));
            this.cal.set(11, this.cal.getActualMaximum(11));
            this.cal.set(12, 59);
            this.cal.set(13, 59);
            this.t1 = this.cal.getTimeInMillis();
            return this;
        }
    }

    private static class DayBounds {
        private Calendar cal;
        private long t1;
        private long t0;

        public DayBounds(Calendar cal) {
            this.cal = cal;
        }

        public long getT1() {
            return this.t1;
        }

        public long getT0() {
            return this.t0;
        }

        public DayBounds invoke() {
            this.cal.set(11, this.cal.getActualMinimum(11));
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.t0 = this.cal.getTimeInMillis();
            this.cal.set(11, this.cal.getActualMaximum(11));
            this.cal.set(12, 59);
            this.cal.set(13, 59);
            this.t1 = this.cal.getTimeInMillis();
            return this;
        }
    }

    private static class HourBounds {
        private Calendar cal;
        private long t1;
        private long t0;

        public HourBounds(Calendar cal) {
            this.cal = cal;
        }

        public long getT1() {
            return this.t1;
        }

        public long getT0() {
            return this.t0;
        }

        public HourBounds invoke() {
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.t0 = this.cal.getTimeInMillis();
            this.cal.set(12, 59);
            this.cal.set(13, 59);
            this.t1 = this.cal.getTimeInMillis();
            return this;
        }
    }
}

