/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.switchyard.component.soap.util.SOAPUtil;
import org.w3c.dom.Node;

public class SOAPFaultInfo
implements Serializable {
    private static final long serialVersionUID = -2522751288771130086L;
    private String _actor;
    private String _code;
    private String _prefix;
    private QName _codeAsQName;
    private String _node;
    private List<Locale> _reasonLocales = new ArrayList<Locale>();
    private Map<Locale, String> _reasonTexts = new HashMap<Locale, String>();
    private String _role;
    private String _string;
    private Locale _stringLocale;
    private List<QName> _subcodes = new ArrayList<QName>();
    private Node _detail;

    public String getActor() {
        return this._actor;
    }

    public void setActor(String actor) {
        this._actor = actor;
    }

    public String getCode() {
        return this._code;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public QName getCodeAsQName() {
        return this._codeAsQName;
    }

    public void setCodeAsQName(QName codeAsQName) {
        this._codeAsQName = codeAsQName;
    }

    public String getNode() {
        return this._node;
    }

    public void setNode(String node) {
        this._node = node;
    }

    public List<Locale> getReasonLocales() {
        return this._reasonLocales;
    }

    public void setReasonLocales(List<Locale> reasonLocales) {
        this._reasonLocales = reasonLocales;
    }

    public void setReasonLocales(Iterator<Locale> reasonLocales) {
        this._reasonLocales = new ArrayList<Locale>();
        while (reasonLocales.hasNext()) {
            this._reasonLocales.add(reasonLocales.next());
        }
    }

    public String getReasonText(Locale locale) {
        return this._reasonTexts.get(locale);
    }

    public Iterator<String> getReasonTexts() {
        return this._reasonTexts.values().iterator();
    }

    public void setReasonTexts(Map<Locale, String> reasonTexts) {
        this._reasonTexts = reasonTexts;
    }

    public void addReasonText(Locale locale, String reasonText) {
        this._reasonTexts.put(locale, reasonText);
    }

    @Deprecated
    public String geRole() {
        return this._role;
    }

    public String getRole() {
        return this._role;
    }

    public void setRole(String role) {
        this._role = role;
    }

    public String getString() {
        return this._string;
    }

    public void setString(String string) {
        this._string = string;
    }

    public Locale getStringLocale() {
        return this._stringLocale;
    }

    public void setStringLocale(Locale stringLocale) {
        this._stringLocale = stringLocale;
    }

    public List<QName> getSubcodes() {
        return this._subcodes;
    }

    public void setSubcodes(List<QName> subcodes) {
        this._subcodes = subcodes;
    }

    public void setSubcodes(Iterator<QName> subcodes) {
        this._subcodes = new ArrayList<QName>();
        while (subcodes.hasNext()) {
            this._subcodes.add(subcodes.next());
        }
    }

    public Node getDetail() {
        return this._detail;
    }

    public void setDetail(Node detail) {
        if (detail != null) {
            this._detail = detail.cloneNode(true);
        }
    }

    public String toString() {
        return "SOAPFaultInfo [_actor=" + this._actor + ", _codeAsQName=" + this._codeAsQName + ", _reasonTexts=" + this._reasonTexts + ", _role=" + this._role + ", _string=" + this._string + ", _stringLocale=" + this._stringLocale + ", _subcodes=" + this._subcodes + ", _detail=" + this._detail + "]";
    }

    public void copyFaultInfo(SOAPMessage soapMessage) throws SOAPException {
        SOAPFault fault = soapMessage.getSOAPBody().getFault();
        this.setActor(fault.getFaultActor());
        this.setCode(fault.getFaultCode());
        this.setPrefix(fault.getFaultCodeAsName().getPrefix());
        this.setCodeAsQName(fault.getFaultCodeAsQName());
        this.setString(fault.getFaultString());
        this.setStringLocale(fault.getFaultStringLocale());
        if (fault.hasDetail()) {
            this.setDetail((Node)fault.getDetail());
        }
        if (SOAPUtil.isSOAP12(soapMessage).booleanValue()) {
            this.setReasonLocales(fault.getFaultReasonLocales());
            Iterator locales = fault.getFaultReasonLocales();
            while (locales.hasNext()) {
                Locale locale = (Locale)locales.next();
                this.addReasonText(locale, fault.getFaultReasonText(locale));
            }
            this.setRole(fault.getFaultRole());
            this.setSubcodes(fault.getFaultSubcodes());
        }
    }
}

