/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.impl.AddressingFeatureApplier;
import org.apache.cxf.ws.addressing.soap.DecoupledFaultHandler;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.SOAPLogger;
import org.switchyard.component.soap.SOAPMessages;
import org.switchyard.component.soap.config.model.InterceptorModel;
import org.switchyard.component.soap.config.model.InterceptorsModel;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.BaseWebService;
import org.switchyard.config.model.property.PropertiesModel;

public class CXFJettyEndpoint
implements Endpoint {
    private static Bus _bus = BusFactory.newInstance().createBus();
    private final JaxWsServerFactoryBean _svrFactory;
    private Server _server;
    private String _publishUrl;

    public CXFJettyEndpoint(String bindingId, SOAPBindingModel config, InboundHandler handler, Interceptor<? extends Message> addressingInterceptor, WebServiceFeature ... features) {
        BaseWebService wsProvider = new BaseWebService();
        wsProvider.setInvocationClassLoader(Classes.getTCCL());
        wsProvider.setConsumer(handler);
        this._svrFactory = new JaxWsServerFactoryBean();
        this._svrFactory.setServiceClass(BaseWebService.class);
        this._svrFactory.setServiceBean((Object)wsProvider);
        this._svrFactory.setBindingId(bindingId);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        ArrayList<WebServiceFeature> cxfFeatures = new ArrayList<WebServiceFeature>();
        Boolean addressingEnabled = false;
        for (WebServiceFeature feature : features) {
            cxfFeatures.add(feature);
            if (feature instanceof AddressingFeature && ((AddressingFeature)feature).isEnabled()) {
                addressingEnabled = true;
                SOAPLogger.ROOT_LOGGER.addressingEnabledRequired(String.valueOf(((AddressingFeature)feature).isEnabled()), String.valueOf(((AddressingFeature)feature).isRequired()));
                continue;
            }
            if (!(feature instanceof MTOMFeature)) continue;
            props.put("mtom-enabled", ((MTOMFeature)feature).isEnabled());
            SOAPLogger.ROOT_LOGGER.mTOMEnabledThreshold(String.valueOf(((MTOMFeature)feature).isEnabled()), String.valueOf(((MTOMFeature)feature).getThreshold()));
        }
        this._svrFactory.getJaxWsServiceFactory().setWsFeatures(cxfFeatures);
        this._svrFactory.setProperties(props);
        if (addressingEnabled.booleanValue()) {
            this._svrFactory.getInInterceptors().add(new DecoupledFaultHandler());
            if (addressingInterceptor != null) {
                this._svrFactory.getOutInterceptors().add(addressingInterceptor);
                this._svrFactory.getOutFaultInterceptors().add(addressingInterceptor);
            }
        }
        this._svrFactory.getInInterceptors().add(new LoggingInInterceptor());
        this._svrFactory.getInInterceptors().add(new SAAJInInterceptor());
        this._svrFactory.getInInterceptors().add(new SoapActionInInterceptor());
        this._svrFactory.getInInterceptors().addAll(CXFJettyEndpoint.getConfiguredInterceptors(config.getInInterceptors()));
        this._svrFactory.getOutInterceptors().addAll(CXFJettyEndpoint.getConfiguredInterceptors(config.getOutInterceptors()));
        this._svrFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        this._svrFactory.getOutInterceptors().add(new SAAJOutInterceptor());
    }

    private static <T extends Interceptor<? extends Message>> List<T> getConfiguredInterceptors(InterceptorsModel interceptorsModel) {
        ArrayList interceptors = new ArrayList();
        if (interceptorsModel != null) {
            for (InterceptorModel interceptorModel : interceptorsModel.getInterceptors()) {
                PropertiesModel propertiesModel;
                Map properties;
                Object interceptor;
                Class<?> interceptorClass;
                if (interceptorModel == null || (interceptorClass = interceptorModel.getClazz(Classes.getTCCL())) == null || (interceptor = CXFJettyEndpoint.newInterceptor(interceptorClass, properties = (propertiesModel = interceptorModel.getProperties()) != null ? propertiesModel.toMap() : new HashMap())) == null) continue;
                interceptors.add(interceptor);
            }
        }
        return interceptors;
    }

    private static <T extends Interceptor<? extends Message>> T newInterceptor(Class<T> interceptorClass, Map<String, String> properties) {
        Interceptor interceptor = null;
        Constructor<T> constructor = CXFJettyEndpoint.getConstructor(interceptorClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                interceptor = (Interceptor)Construction.construct(interceptorClass);
            } else if (parameterTypes.length == 1) {
                interceptor = (Interceptor)Construction.construct(interceptorClass, (Class[])parameterTypes, (Object[])new Object[]{properties});
            }
        }
        catch (Throwable t) {
            throw SOAPMessages.MESSAGES.couldNotInstantiateInterceptor(interceptorClass.getName(), t);
        }
        return (T)interceptor;
    }

    private static <T extends Interceptor<? extends Message>> Constructor<T> getConstructor(Class<T> interceptorClass) {
        Class[][] constructorParameterTypes = new Class[][]{{Map.class}, new Class[0]};
        Constructor<T> constructor = null;
        for (Class[] parameterTypes : constructorParameterTypes) {
            try {
                constructor = interceptorClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    public JaxWsServerFactoryBean getEndpoint() {
        return this._svrFactory;
    }

    public void publish(String publishUrl) {
        this._publishUrl = publishUrl;
        SOAPLogger.ROOT_LOGGER.publishingWebServiceAt(this._publishUrl);
        this._svrFactory.setAddress(publishUrl);
        this._server = this._svrFactory.create();
        this._server.start();
    }

    public void start() {
    }

    public void stop() {
        SOAPLogger.ROOT_LOGGER.stoppingWebServiceAt(this._publishUrl);
        this._server.stop();
        this._server.destroy();
    }

    static {
        try {
            _bus.setExtension((Object)new AddressingFeatureApplier(), WSAddressingFeature.WSAddressingFeatureApplier.class);
            _bus.setExtension((Object)CXFJettyEndpoint.class.getClassLoader(), ClassLoader.class);
        }
        catch (Throwable t) {
            t.fillInStackTrace();
        }
    }
}

