/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.callback.handler;

import java.io.IOException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.switchyard.security.BaseSecurityMessages;
import org.switchyard.security.callback.handler.SwitchYardCallbackHandler;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PasswordCredential;

public class NamePasswordCallbackHandler
extends SwitchYardCallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Set<Credential> credentials = this.getCredentials();
        if (credentials == null) {
            throw BaseSecurityMessages.MESSAGES.credentialsNotSet();
        }
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                for (Credential cred : credentials) {
                    if (!(cred instanceof NameCredential)) continue;
                    ((NameCallback)cb).setName(((NameCredential)cred).getName());
                }
                continue;
            }
            if (!(cb instanceof PasswordCallback)) continue;
            for (Credential cred : credentials) {
                if (!(cred instanceof PasswordCredential)) continue;
                ((PasswordCallback)cb).setPassword(((PasswordCredential)cred).getPassword());
            }
        }
    }
}

