/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 16384;

    public static byte[] read(URL input) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(16384);
        StreamUtils.copy((OutputStream)byteStream, input);
        return byteStream.toByteArray();
    }

    public static byte[] read(InputStream source) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(16384);
        StreamUtils.copy((OutputStream)byteStream, source);
        return byteStream.toByteArray();
    }

    public static void copy(OutputStream dest, InputStream source, int bufSize) throws IOException {
        int read;
        byte[] buf = new byte[bufSize];
        while ((read = source.read(buf)) != -1) {
            dest.write(buf, 0, read);
        }
    }

    public static void copy(Writer dest, Reader source, int bufSize) throws IOException {
        int read;
        char[] buf = new char[bufSize];
        while ((read = source.read(buf)) != -1) {
            dest.write(buf, 0, read);
        }
    }

    public static void copy(OutputStream dest, InputStream source) throws IOException {
        StreamUtils.copy(dest, source, 16384);
    }

    public static void copy(OutputStream dest, URL source) throws IOException {
        InputStream urlStream = source.openStream();
        StreamUtils.copy(dest, urlStream);
        urlStream.close();
    }

    public static void write(OutputStream dest, Serializable src) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(dest);
        oos.writeObject(src);
        oos.flush();
    }

    public static Object readObj(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream iis = new ObjectInputStream(is);
        return iis.readObject();
    }

    public static void extractJar(File dest, InputStream is) throws IOException {
        JarEntry je;
        JarInputStream jis = new JarInputStream(is);
        while ((je = jis.getNextJarEntry()) != null) {
            File outputFile = new File(dest, je.getName());
            if (je.isDirectory()) {
                outputFile.mkdirs();
            } else {
                outputFile.getParentFile().mkdirs();
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
                StreamUtils.copy((OutputStream)bos, jis);
                bos.flush();
                bos.close();
            }
            jis.closeEntry();
        }
    }
}

