/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.processors;

import javax.xml.namespace.QName;
import org.apache.camel.Processor;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.TransformSequence;

public class ConsumerCallbackProcessor
implements Processor {
    private TransformHandler _transform;

    public ConsumerCallbackProcessor(TransformHandler transform) {
        this._transform = transform;
    }

    public void process(org.apache.camel.Exchange ex) throws Exception {
        ExchangeImpl syEx = (ExchangeImpl)ex.getProperty("SwitchYardExchange", ExchangeImpl.class);
        HandlerException error = (HandlerException)ex.getProperty("CamelExceptionCaught", HandlerException.class);
        if (error != null) {
            this.handleFault(syEx, error);
        } else {
            syEx.getReplyHandler().handleMessage((Exchange)syEx);
        }
    }

    private void handleFault(ExchangeImpl exchange, HandlerException ex) {
        Throwable error = ex.isWrapper() ? ex.getCause() : ex;
        Message faultMessage = exchange.createMessage().setContent((Object)error);
        exchange.sendFault(faultMessage);
        ExchangeContract contract = exchange.getContract();
        QName exceptionTypeName = null;
        if (contract.getProviderOperation() != null) {
            exceptionTypeName = contract.getProviderOperation().getFaultType();
        }
        QName invokerFaultTypeName = contract.getConsumerOperation().getFaultType();
        if (exceptionTypeName == null) {
            exceptionTypeName = JavaService.toMessageType(error.getClass());
        }
        if (exceptionTypeName != null && invokerFaultTypeName != null) {
            TransformSequence.from((QName)exceptionTypeName).to(invokerFaultTypeName).associateWith((Exchange)exchange, Scope.OUT);
            this._transform.handleFault((Exchange)exchange);
        }
        exchange.getReplyHandler().handleFault((Exchange)exchange);
    }
}

