/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.processors;

import java.util.List;
import org.apache.camel.Processor;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.bus.camel.processors.ConsumerCallbackProcessor;
import org.switchyard.bus.camel.processors.HandlerProcessor;
import org.switchyard.bus.camel.processors.ProviderProcessor;
import org.switchyard.handlers.AddressingHandler;
import org.switchyard.handlers.PolicyHandler;
import org.switchyard.handlers.SecurityHandler;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.handlers.ValidateHandler;

public enum Processors {
    DOMAIN_HANDLERS{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap(domain.getHandlers());
        }
    }
    ,
    ADDRESSING{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap((ExchangeHandler)new AddressingHandler(domain));
        }
    }
    ,
    TRANSACTION_HANDLER{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap((ExchangeHandler)new TransactionHandler());
        }
    }
    ,
    SECURITY{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap((ExchangeHandler)new SecurityHandler(domain.getServiceSecurity()));
        }
    }
    ,
    GENERIC_POLICY{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap((ExchangeHandler)new PolicyHandler());
        }
    }
    ,
    VALIDATION{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap((ExchangeHandler)new ValidateHandler(domain.getValidatorRegistry()));
        }
    }
    ,
    TRANSFORMATION{

        @Override
        public Processor create(ServiceDomain domain) {
            return Processors.wrap((ExchangeHandler)new TransformHandler(domain.getTransformerRegistry()));
        }
    }
    ,
    PROVIDER_CALLBACK{

        @Override
        public Processor create(ServiceDomain domain) {
            return new ProviderProcessor();
        }
    }
    ,
    CONSUMER_CALLBACK{

        @Override
        public Processor create(ServiceDomain domain) {
            return new ConsumerCallbackProcessor(new TransformHandler(domain.getTransformerRegistry()));
        }
    };


    public Processor create(ServiceDomain domain) {
        throw new IllegalArgumentException();
    }

    private static Processor wrap(ExchangeHandler handler) {
        return new HandlerProcessor(handler);
    }

    private static Processor wrap(List<ExchangeHandler> handlers) {
        return new HandlerProcessor(handlers);
    }
}

