/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.audit;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.internal.ExchangeImpl;

public class FaultProcessor
extends DelegateAsyncProcessor {
    public FaultProcessor(Processor target) {
        super(target);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        return super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync) {
                    ExchangeImpl exc = (ExchangeImpl)exchange.getProperty("SwitchYardExchange", ExchangeImpl.class);
                    FaultProcessor.this.handle(exchange.getException(), exc);
                }
                callback.done(doneSync);
            }
        });
    }

    protected void handle(Throwable throwable, ExchangeImpl exchange) {
        if (throwable != null && ExchangeState.OK == exchange.getState()) {
            HandlerException content = this.detectHandlerException(throwable);
            exchange.sendFault(exchange.createMessage().setContent((Object)content));
        }
    }

    private HandlerException detectHandlerException(Throwable throwable) {
        if (throwable instanceof HandlerException) {
            return (HandlerException)throwable;
        }
        return new HandlerException(throwable);
    }

    public String toString() {
        return "FaultProcessor [" + this.getProcessor() + "]";
    }
}

