/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.audit;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.bus.camel.CamelHelper;
import org.switchyard.bus.camel.ErrorListener;
import org.switchyard.common.lang.Strings;

public class FaultProcessor
extends DelegateAsyncProcessor {
    private Logger _logger = Logger.getLogger(FaultProcessor.class);

    public FaultProcessor(Processor target) {
        super(target);
    }

    public boolean process(final org.apache.camel.Exchange exchange, final AsyncCallback callback) {
        return super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync) {
                    Exchange exc = CamelHelper.getSwitchYardExchange(exchange);
                    if (exchange.getException() != null) {
                        FaultProcessor.this.handle(exchange.getException(), exchange, exc);
                    }
                }
                callback.done(doneSync);
            }
        });
    }

    protected void handle(Throwable throwable, org.apache.camel.Exchange camel, Exchange exchange) {
        if (ExchangeState.OK == exchange.getState()) {
            this.dumpExceptionContents(throwable);
            this.notifyListeners(camel.getContext(), exchange, throwable);
            Throwable content = this.detectHandlerException(throwable);
            exchange.sendFault(exchange.createMessage().setContent((Object)content));
        } else {
            this._logger.error((Object)"Unexpected exception thrown during handling FAULT response. This exception can not be handled, thus it's marked as handled and only logged. If you don't want see messages like this consider handling exceptions in your handler logic", throwable);
            ExchangeHelper.setFailureHandled((org.apache.camel.Exchange)camel);
        }
    }

    protected void dumpExceptionContents(Throwable throwable) {
        if (this._logger.isDebugEnabled()) {
            String message = "Caught exception of type %s with message: %s";
            String causeTrace = "";
            if (throwable.getCause() != null) {
                String causedBy = "\n%sCaused by exception of type %s, message: %s";
                int depth = 0;
                for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
                    causeTrace = causeTrace + String.format(causedBy, Strings.repeat((String)"  ", (int)(++depth)), cause.getClass().getName(), cause.getMessage());
                }
            }
            this._logger.debug((Object)(String.format(message, throwable.getClass().getName(), throwable.getMessage()) + causeTrace), throwable);
        }
    }

    protected void notifyListeners(CamelContext context, Exchange exchange, Throwable exception) {
        Map listeners = context.getRegistry().lookupByType(ErrorListener.class);
        if (listeners != null && listeners.size() > 0) {
            for (Map.Entry entry : listeners.entrySet()) {
                try {
                    ((ErrorListener)entry.getValue()).notify(exchange, exception);
                }
                catch (Exception e) {
                    this._logger.error((Object)("Error listener " + (String)entry.getKey() + " failed to handle exception " + exception.getClass()));
                }
            }
        }
    }

    private Throwable detectHandlerException(Throwable throwable) {
        if (throwable instanceof HandlerException) {
            return (HandlerException)throwable;
        }
        return new HandlerException(throwable);
    }

    public String toString() {
        return "FaultProcessor [" + this.getProcessor() + "]";
    }
}

