/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.processors;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.bus.camel.CamelExchange;
import org.switchyard.bus.camel.ErrorListener;

public class ErrorHandlingProcessor
implements Processor {
    private static final Logger LOG = Logger.getLogger(ErrorHandlingProcessor.class);

    public void process(org.apache.camel.Exchange exchange) throws Exception {
        CamelExchange ex = new CamelExchange(exchange);
        if (ex.getState() != ExchangeState.FAULT) {
            Exception exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
            this.notifyListeners(exchange.getContext(), (Exchange)ex, exception);
            Throwable content = this.detectHandlerException(exception);
            Property rollbackOnFaultProperty = ex.getContext().getProperty("org.switchyard.rollbackOnFault");
            if (rollbackOnFaultProperty == null || rollbackOnFaultProperty.getValue() == null) {
                ex.getContext().setProperty("org.switchyard.rollbackOnFault", (Object)Boolean.TRUE, Scope.EXCHANGE);
            }
            ex.sendFault(ex.createMessage().setContent(content));
            ExchangeHelper.setFailureHandled((org.apache.camel.Exchange)exchange);
        }
    }

    private Throwable detectHandlerException(Throwable throwable) {
        if (throwable instanceof HandlerException) {
            return (HandlerException)throwable;
        }
        return new HandlerException(throwable);
    }

    private void notifyListeners(CamelContext context, Exchange exchange, Throwable exception) {
        Map listeners = context.getRegistry().lookupByType(ErrorListener.class);
        if (listeners != null && listeners.size() > 0) {
            for (Map.Entry entry : listeners.entrySet()) {
                try {
                    ((ErrorListener)entry.getValue()).notify(exchange, exception);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error listener " + (String)entry.getKey() + " failed to handle exception " + exception.getClass()));
                }
            }
        }
    }
}

