/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.processors;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.Processor;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.bus.camel.CamelExchange;

public class HandlerProcessor
implements Processor {
    private List<ExchangeHandler> _handlers;

    public HandlerProcessor(ExchangeHandler handler) {
        this(Arrays.asList(handler));
    }

    public HandlerProcessor(List<ExchangeHandler> handlers) {
        this._handlers = handlers;
    }

    public void process(org.apache.camel.Exchange ex) throws Exception {
        CamelExchange exchange = new CamelExchange(ex);
        for (ExchangeHandler handler : this._handlers) {
            if (exchange.getState() == ExchangeState.FAULT) {
                handler.handleFault((Exchange)exchange);
                continue;
            }
            handler.handleMessage((Exchange)exchange);
        }
    }

    public String toString() {
        return "HandlerProcessor [" + this._handlers + "]";
    }
}

