/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.BusMessages;
import org.switchyard.bus.camel.CamelCompositeContext;
import org.switchyard.bus.camel.CamelMessage;
import org.switchyard.bus.camel.ExchangeDispatcher;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.runtime.event.ExchangeCompletionEvent;
import org.switchyard.runtime.event.ExchangeInitiatedEvent;

public class CamelExchange
implements Exchange {
    private static final String DISPATCHER = "org.switchyard.bus.camel.dispatcher";
    private static final String CONSUMER = "org.switchyard.bus.camel.consumer";
    private static final String PROVIDER = "org.switchyard.bus.camel.provider";
    private static final String CONTRACT = "org.switchyard.bus.camel.contract";
    private static final String REPLY_HANDLER = "org.switchyard.bus.camel.replyHandler";
    private static final String PHASE = "org.switchyard.bus.camel.phase";
    private static final String FAULT = "org.switchyard.bus.camel.fault";
    public static final String LABELS = "org.switchyard.bus.camel.labels";
    public static final String MESSAGE_SENT = "org.switchyard.bus.camel.messageSent";
    private org.apache.camel.Exchange _exchange;

    public CamelExchange(ExchangeDispatcher dispatch, org.apache.camel.Exchange exchange, ExchangeHandler replyHandler) {
        this._exchange = exchange;
        Map properties = exchange.getProperties();
        if (!properties.containsKey(DISPATCHER)) {
            this._exchange.setProperty(DISPATCHER, (Object)dispatch);
        }
        if (!properties.containsKey(REPLY_HANDLER)) {
            this._exchange.setProperty(REPLY_HANDLER, (Object)replyHandler);
        }
    }

    public CamelExchange(org.apache.camel.Exchange exchange) {
        this((ExchangeDispatcher)exchange.getProperty(DISPATCHER, ExchangeDispatcher.class), exchange, (ExchangeHandler)exchange.getProperty(REPLY_HANDLER, ExchangeHandler.class));
    }

    public Context getContext() {
        return new CamelCompositeContext(this._exchange, (org.apache.camel.Message)this.getMessage());
    }

    public Context getContext(Message message) {
        if (this._exchange.getIn() == message) {
            return this.getContext();
        }
        return message.getContext();
    }

    public ServiceReference getConsumer() {
        return (ServiceReference)this._exchange.getProperty(CONSUMER, ServiceReference.class);
    }

    public Service getProvider() {
        return (Service)this._exchange.getProperty(PROVIDER, Service.class);
    }

    public BaseExchangeContract getContract() {
        if (this._exchange.getProperty(CONTRACT) == null) {
            this._exchange.setProperty(CONTRACT, (Object)new BaseExchangeContract());
        }
        return (BaseExchangeContract)this._exchange.getProperty(CONTRACT, BaseExchangeContract.class);
    }

    public Exchange consumer(ServiceReference consumer, ServiceOperation operation) {
        this._exchange.setProperty(CONSUMER, (Object)consumer);
        this.getContract().setConsumerOperation(operation);
        return this;
    }

    public Exchange provider(Service provider, ServiceOperation operation) {
        if (this.getPhase() == ExchangePhase.OUT) {
            throw BusMessages.MESSAGES.cannotChangeProviderMetadata();
        }
        this._exchange.setProperty(PROVIDER, (Object)provider);
        this.getContract().setProviderOperation(operation);
        return this;
    }

    public CamelMessage getMessage() {
        return (CamelMessage)this._exchange.getIn();
    }

    public CamelMessage createMessage() {
        return new CamelMessage(this._exchange);
    }

    public void send(Message message) {
        org.apache.camel.Message camelMsg = this.extract(message);
        if (this.getPhase() == null) {
            this._exchange.setProperty(PHASE, (Object)ExchangePhase.IN);
            this._exchange.setIn(camelMsg);
            this.getContext().setProperty("org.switchyard.messageId", (Object)camelMsg.getMessageId());
            this.initInContentType();
        } else {
            this._exchange.setProperty(PHASE, (Object)ExchangePhase.OUT);
            String id = (String)this.getContext().getPropertyValue("org.switchyard.messageId");
            this._exchange.setIn(camelMsg);
            this.getContext().setProperty("org.switchyard.relatesTo", (Object)id);
            this.getContext().setProperty("org.switchyard.messageId", (Object)camelMsg.getMessageId());
            this.initOutContentType();
        }
        this.sendInternal();
    }

    private org.apache.camel.Message extract(Message message) {
        if (message instanceof CamelMessage) {
            CamelMessage msg = (CamelMessage)message;
            if (msg.isSent()) {
                throw BusMessages.MESSAGES.cannotSendMessageTwice();
            }
            msg.sent();
            return msg;
        }
        throw BusMessages.MESSAGES.camelExchangeOnlyCamelMessages();
    }

    public void sendFault(Message message) {
        org.apache.camel.Message extract = this.extract(message);
        this._exchange.setProperty(PHASE, (Object)ExchangePhase.OUT);
        String id = (String)this.getContext().getPropertyValue("org.switchyard.messageId");
        this._exchange.setIn(extract);
        this._exchange.setProperty(FAULT, (Object)true);
        this.getContext().setProperty("org.switchyard.relatesTo", (Object)id);
        this.getContext().setProperty("org.switchyard.messageId", (Object)extract.getMessageId());
        Property rollbackOnFaultProperty = this.getContext().getProperty("org.switchyard.rollbackOnFault");
        if (rollbackOnFaultProperty == null || rollbackOnFaultProperty.getValue() == null) {
            this.getContext().setProperty("org.switchyard.rollbackOnFault", (Object)Boolean.FALSE, Scope.EXCHANGE);
        }
        this.sendInternal();
    }

    private void initInContentType() {
        QName exchangeInputType = this.getContract().getConsumerOperation().getInputType();
        if (exchangeInputType != null) {
            this.getContext().setProperty("org.switchyard.contentType", (Object)exchangeInputType).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    private void initOutContentType() {
        QName exchangeOutputType = this.getContract().getProviderOperation().getOutputType();
        if (exchangeOutputType != null) {
            this.getContext().setProperty("org.switchyard.contentType", (Object)exchangeOutputType).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    private void sendInternal() {
        ServiceDomain domain = ((SwitchYardCamelContext)this._exchange.getContext()).getServiceDomain();
        ExchangePhase sendPhase = this.getPhase();
        if (ExchangePhase.IN.equals((Object)this.getPhase())) {
            this.getContext().setProperty("org.switchyard.exchangeInitiatedNS", (Object)Long.toString(System.nanoTime()), Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            domain.getEventPublisher().publish((EventObject)new ExchangeInitiatedEvent((Exchange)this));
        }
        ((ExchangeDispatcher)this._exchange.getProperty(DISPATCHER, ExchangeDispatcher.class)).dispatch(this);
        if (this.isDone(sendPhase)) {
            long duration = System.nanoTime() - (Long)this._exchange.getProperty("org.switchyard.exchangeInitiatedNS", (Object)0, Long.class);
            this.getContext().setProperty("org.switchyard.exchangeDurationMS", (Object)TimeUnit.NANOSECONDS.toMillis(duration)).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            domain.getEventPublisher().publish((EventObject)new ExchangeCompletionEvent((Exchange)this));
        }
    }

    public ExchangeState getState() {
        return CamelExchange.isFault(this._exchange) ? ExchangeState.FAULT : ExchangeState.OK;
    }

    public ExchangePhase getPhase() {
        return (ExchangePhase)this._exchange.getProperty(PHASE, ExchangePhase.class);
    }

    public org.apache.camel.Exchange getExchange() {
        return this._exchange;
    }

    public ExchangeHandler getReplyHandler() {
        return (ExchangeHandler)this._exchange.getProperty(REPLY_HANDLER, ExchangeHandler.class);
    }

    private boolean isDone(ExchangePhase phase) {
        ExchangePattern mep = this.getContract().getConsumerOperation().getExchangePattern();
        return ExchangePhase.IN.equals((Object)phase) && ExchangePattern.IN_ONLY.equals((Object)mep) || ExchangePhase.OUT.equals((Object)phase) && ExchangePattern.IN_OUT.equals((Object)mep);
    }

    public static boolean isFault(org.apache.camel.Exchange exchange) {
        return (Boolean)exchange.getProperty(FAULT, (Object)false, Boolean.class);
    }

    public ExchangePattern getPattern() {
        ExchangePattern pattern = null;
        if (this.getContract() != null) {
            pattern = this.getContract().getConsumerOperation().getExchangePattern();
        }
        return pattern;
    }
}

