/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.audit;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.jboss.logging.Logger;
import org.switchyard.bus.camel.BusLogger;
import org.switchyard.bus.camel.BusMessages;
import org.switchyard.bus.camel.CamelExchange;

public class FaultProcessor
extends DelegateAsyncProcessor {
    private Logger _logger = Logger.getLogger(FaultProcessor.class);

    public FaultProcessor(Processor target) {
        super(target);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        return super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync && CamelExchange.isFault(exchange) && exchange.getException() != null) {
                    FaultProcessor.this.handle(exchange.getException(), exchange);
                    exchange.setException(null);
                }
                callback.done(doneSync);
            }
        });
    }

    protected void handle(Throwable throwable, Exchange exchange) {
        BusLogger.ROOT_LOGGER.exceptionDuringFaultResponse(throwable);
    }

    public String toString() {
        return BusMessages.MESSAGES.faultProcessorString((Processor)this.getProcessor());
    }
}

