/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.camel.NamedNode;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.BusLogger;
import org.switchyard.bus.camel.BusMessages;
import org.switchyard.bus.camel.CamelExchangeBusRouteBuilder;
import org.switchyard.bus.camel.ExchangeDispatcher;
import org.switchyard.bus.camel.processors.Processors;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;

public class CamelExchangeBus
implements ExchangeBus {
    private Logger _logger = Logger.getLogger(CamelExchangeBus.class);
    private HashMap<QName, ExchangeDispatcher> _dispatchers = new HashMap();
    private SwitchYardCamelContext _camelContext;

    public CamelExchangeBus(SwitchYardCamelContext context) {
        this._camelContext = context;
    }

    public void init(ServiceDomain domain) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Initialization of CamelExchangeBus for domain " + domain.getName()));
        }
        SimpleRegistry registry = this._camelContext.getWritebleRegistry();
        for (Processors processor : Processors.values()) {
            registry.put((Object)processor.name(), (Object)processor.create(domain));
        }
        this._camelContext.setApplicationContextClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public synchronized void start() {
        try {
            this._camelContext.start();
        }
        catch (Exception ex) {
            throw BusMessages.MESSAGES.failedToStartBus(ex);
        }
    }

    public synchronized void stop() {
        try {
            this._dispatchers.clear();
            this._camelContext.stop();
        }
        catch (Exception ex) {
            throw BusMessages.MESSAGES.failedToStopBus(ex);
        }
    }

    public Dispatcher getDispatcher(ServiceReference reference) {
        return this._dispatchers.get(reference.getName());
    }

    public ExchangeDispatcher createDispatcher(ServiceReference reference) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Creating Camel dispatcher for " + reference.getName()));
        }
        String endpoint = "direct:" + reference.getName();
        CamelExchangeBusRouteBuilder rb = new CamelExchangeBusRouteBuilder(endpoint, reference);
        try {
            if (this._camelContext.getRoute(endpoint) != null) {
                this._camelContext.removeRoute(endpoint);
                if (this._logger.isInfoEnabled()) {
                    BusLogger.ROOT_LOGGER.removeRoute(endpoint);
                }
            }
            this._camelContext.addRoutes((RoutesBuilder)rb);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Created route for " + endpoint + ", definition is: " + ModelHelper.dumpModelAsXml((NamedNode)rb.getRouteCollection())));
            }
        }
        catch (Exception ex) {
            throw BusMessages.MESSAGES.failedToCreateRoute(reference.getName(), ex);
        }
        ExchangeDispatcher dispatcher = new ExchangeDispatcher((ModelCamelContext)this._camelContext, reference);
        this._dispatchers.put(reference.getName(), dispatcher);
        return dispatcher;
    }
}

