/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import org.apache.log4j.Logger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.modules.Module;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;

public class SwitchYardCdiIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String SWITCHYARD_CDI_EXTENSION = "org.switchyard.component.bean.SwitchYardCDIServiceDiscovery";
    private static final String DELTASPIKE_CDI_EXTENSION = "org.apache.deltaspike.core.api.provider.BeanManagerProvider";
    private static Logger _logger = Logger.getLogger(SwitchYardCdiIntegrationProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            DeploymentUnit parent;
            DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            synchronized (deploymentUnit2) {
                this.checkExtension(SWITCHYARD_CDI_EXTENSION, deploymentUnit, parent);
                this.checkExtension(DELTASPIKE_CDI_EXTENSION, deploymentUnit, parent);
            }
        } else {
            _logger.debug((Object)("SwitchYard Application for deployment unit '" + deploymentUnit.getName() + "' does not appear to contain CDI Beans " + "(no META-INF/beans.xml file in unit).  Not attaching SwitchYard CDI Discovery Extension to deployment."));
        }
    }

    private void checkExtension(String extensionName, DeploymentUnit deploymentUnit, DeploymentUnit parent) throws DeploymentUnitProcessingException {
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        Class extensionClass = null;
        try {
            extensionClass = module.getClassLoader().loadClass(extensionName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentUnitProcessingException((Throwable)cnfe);
        }
        if (extensionClass == null) {
            throw ExtensionMessages.MESSAGES.extensionNotfound(extensionName);
        }
        WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
        extensions.tryRegisterExtension(extensionClass, deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

