/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import org.switchyard.ServiceDomain;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.transform.TransformerRegistryLoader;

public abstract class AbstractDeployment {
    public static final String SWITCHYARD_XML = "/META-INF/switchyard.xml";
    private AbstractDeployment _parentDeployment;
    private ServiceDomain _serviceDomain;
    private TransformerRegistryLoader _transformerRegistryLoader;
    private SwitchYardModel _switchyardConfig;

    protected AbstractDeployment(SwitchYardModel configModel) {
        this._switchyardConfig = configModel;
    }

    public void setParentDeployment(AbstractDeployment parentDeployment) {
        this._parentDeployment = parentDeployment;
    }

    public void init(ServiceDomain appServiceDomain) {
        if (appServiceDomain == null) {
            throw new IllegalArgumentException("null 'appServiceDomain' argument.");
        }
        this._serviceDomain = appServiceDomain;
        this._transformerRegistryLoader = new TransformerRegistryLoader(appServiceDomain.getTransformerRegistry());
        this._transformerRegistryLoader.loadOOTBTransforms();
    }

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();

    public ServiceDomain getDomain() {
        if (this._parentDeployment == null) {
            return this._serviceDomain;
        }
        return this._parentDeployment.getDomain();
    }

    public TransformerRegistryLoader getTransformerRegistryLoader() {
        return this._transformerRegistryLoader;
    }

    protected SwitchYardModel getConfig() {
        return this._switchyardConfig;
    }
}

