/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelResource;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Activation;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;

public class Deployment
extends AbstractDeployment {
    private static final String JAVA_INTERFACE = "java";
    private static final String WSDL_INTERFACE = "wsdl";
    private static Logger _log = Logger.getLogger(Deployment.class);
    private Map<String, Activator> _activators = new HashMap<String, Activator>();
    private List<Activation> _services = new LinkedList<Activation>();
    private List<Activation> _serviceBindings = new LinkedList<Activation>();
    private List<Activation> _references = new LinkedList<Activation>();
    private List<Activation> _referenceBindings = new LinkedList<Activation>();

    public Deployment(InputStream configStream) throws IOException {
        super((SwitchYardModel)new ModelResource().pull(configStream));
    }

    public Deployment(SwitchYardModel configModel) {
        super(configModel);
    }

    @Override
    public void init(ServiceDomain appServiceDomain) {
        super.init(appServiceDomain);
        _log.debug((Object)("Initializing deployment for application " + this.getConfig().getName()));
        this.registerTransformers();
        this.createActivators();
    }

    @Override
    public void start() {
        _log.debug((Object)("Starting deployment " + this.getConfig().getName()));
        try {
            this.deployReferenceBindings();
            this.deployServices();
            this.deployReferences();
            this.deployServiceBindings();
        }
        catch (RuntimeException e1) {
            _log.debug((Object)("Undeploying partially deployed artifacts of failed deployment " + this.getConfig().getName()));
            try {
                this.stop();
            }
            catch (RuntimeException e2) {
                _log.debug((Object)("Failed to properly undeploy a partial/failed deployment " + this.getConfig().getName()), (Throwable)e2);
            }
            throw e1;
        }
    }

    @Override
    public void stop() {
        _log.debug((Object)("Stopping deployment " + this.getConfig().getName()));
        this.undeployServiceBindings();
        this.undeployServices();
        this.undeployReferences();
        this.undeployReferenceBindings();
    }

    @Override
    public void destroy() {
        _log.debug((Object)("Destroying deployment " + this.getConfig().getName()));
        this.destroyDomain();
        this._services.clear();
        this._serviceBindings.clear();
        this._references.clear();
        this._referenceBindings.clear();
        this.getTransformerRegistryLoader().unregisterTransformers();
    }

    public Activator getActivator(String type) {
        return this._activators.get(type);
    }

    private Activator getActivator(ComponentModel component) {
        String type = component.getImplementation().getType();
        return this.getActivator(type);
    }

    private void createActivators() {
        ServiceLoader<Activator> activatorLoader = ServiceLoader.load(Activator.class);
        for (Activator activator : activatorLoader) {
            Collection<String> activationTypes = activator.getActivationTypes();
            for (String type : activationTypes) {
                this._activators.put(type, activator);
            }
        }
    }

    private void registerTransformers() {
        _log.debug((Object)"Registering configured Transformers ...");
        TransformsModel transforms = this.getConfig().getTransforms();
        this.getTransformerRegistryLoader().registerTransformers(transforms);
    }

    private void deployReferenceBindings() {
        _log.debug((Object)"Deploying reference bindings ...");
        for (CompositeReferenceModel reference : this.getConfig().getComposite().getReferences()) {
            for (BindingModel binding : reference.getBindings()) {
                QName refQName = reference.getQName();
                _log.debug((Object)("Deploying binding " + binding.getType() + " for reference " + reference.getName()));
                Activator activator = this.getActivator(binding.getType());
                ExchangeHandler handler = activator.init(refQName, (Model)reference);
                ServiceInterface si = this.getComponentReferenceInterface(reference.getComponentReference());
                ServiceReference serviceRef = si != null ? this.getDomain().registerService(refQName, handler, si) : this.getDomain().registerService(refQName, handler);
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._referenceBindings.add(activation);
            }
        }
    }

    private ServiceInterface getComponentReferenceInterface(ComponentReferenceModel reference) {
        ServiceInterface serviceInterface = null;
        if (reference != null && reference.getInterface() != null) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)reference.getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface getComponentServiceInterface(ComponentServiceModel service) {
        ServiceInterface serviceInterface = null;
        if (service != null && service.getInterface() != null) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)service.getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface loadServiceInterface(InterfaceModel intfModel) {
        JavaService serviceInterface = null;
        if (intfModel != null) {
            if (this.isJavaInterface(intfModel.getType())) {
                serviceInterface = JavaService.fromClass(this.loadClass(intfModel.getInterface()));
            } else if (intfModel.getType().equals(WSDL_INTERFACE)) {
                try {
                    serviceInterface = WSDLService.fromWSDL((String)intfModel.getInterface());
                }
                catch (WSDLReaderException wsdlre) {
                    throw new SwitchYardException((Throwable)wsdlre);
                }
            }
        }
        return serviceInterface;
    }

    private boolean isJavaInterface(String type) {
        return type.equals(JAVA_INTERFACE);
    }

    private void deployServices() {
        _log.debug((Object)"Deploying services ...");
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            Activator activator = this.getActivator(component);
            for (ComponentServiceModel service : component.getServices()) {
                _log.debug((Object)("Registering service " + service.getName() + " for component " + component.getImplementation().getType()));
                ExchangeHandler handler = activator.init(service.getQName(), (Model)service);
                ServiceInterface serviceIntf = this.getComponentServiceInterface(service);
                ServiceReference serviceRef = serviceIntf != null ? this.getDomain().registerService(service.getQName(), handler, serviceIntf) : this.getDomain().registerService(service.getQName(), handler);
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._services.add(activation);
            }
        }
    }

    private void deployReferences() {
        _log.debug((Object)"Deploying references ...");
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            Activator activator = this.getActivator(component);
            for (ComponentReferenceModel reference : component.getReferences()) {
                _log.debug((Object)("Registering reference " + reference.getName() + " for component " + component.getImplementation().getType()));
                ServiceReference service = this.getDomain().getService(reference.getQName());
                activator.init(reference.getQName(), (Model)reference);
                Activation activation = new Activation(service, activator);
                activation.start();
                this._references.add(activation);
            }
        }
    }

    private void deployServiceBindings() {
        _log.debug((Object)"Deploying service bindings ...");
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            for (BindingModel binding : service.getBindings()) {
                _log.debug((Object)("Deploying binding " + binding.getType() + " for service " + service.getName()));
                Activator activator = this.getActivator(binding.getType());
                ServiceReference serviceRef = this.getDomain().getService(service.getQName());
                activator.init(serviceRef.getName(), (Model)service);
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._serviceBindings.add(activation);
            }
        }
    }

    private void undeployServiceBindings() {
        _log.debug((Object)"Undeploying reference bindings ...");
        for (Activation activation : this._serviceBindings) {
            activation.stop();
            activation.destroy();
        }
    }

    private void undeployServices() {
        _log.debug((Object)"Undeploying services ...");
        for (Activation activation : this._services) {
            activation.stop();
            activation.destroy();
        }
    }

    private void undeployReferences() {
        _log.debug((Object)"Undeploying references ...");
        for (Activation activation : this._references) {
            activation.stop();
            activation.destroy();
        }
    }

    private void undeployReferenceBindings() {
        _log.debug((Object)"Undeploying reference bindings ...");
        for (Activation activation : this._referenceBindings) {
            activation.stop();
            activation.destroy();
        }
    }

    private void destroyDomain() {
    }

    private Class<?> loadClass(String className) {
        return Classes.forName((String)className, this.getClass());
    }
}

