/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.switchyard.ServiceDomain;
import org.switchyard.deploy.Activator;

public abstract class BaseActivator
implements Activator {
    private List<String> _activationTypes = new LinkedList<String>();
    private ServiceDomain _serviceDomain;

    protected BaseActivator(String ... types) {
        if (types != null) {
            this._activationTypes.addAll(Arrays.asList(types));
        }
    }

    public void setServiceDomain(ServiceDomain serviceDomain) {
        this._serviceDomain = serviceDomain;
    }

    public ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    @Override
    public boolean canActivate(String type) {
        return this._activationTypes.contains(type);
    }

    @Override
    public Collection<String> getActivationTypes() {
        return Collections.unmodifiableList(this._activationTypes);
    }
}

