/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.AbstractParser;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.XMLReaderHierarchyChangeListener;
import org.milyn.delivery.sax.SAXHandler;
import org.milyn.xml.hierarchy.HierarchyChangeReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParser
extends AbstractParser {
    private SAXHandler saxHandler;

    public SAXParser(ExecutionContext execContext) {
        super(execContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Writer parse(Source source, Result result, ExecutionContext executionContext) throws SAXException, IOException {
        Writer writer = this.getWriter(result, executionContext);
        ContentDeliveryConfig deliveryConfig = executionContext.getDeliveryConfig();
        XMLReader saxReader = SAXParser.getXMLReader(executionContext);
        this.saxHandler = new SAXHandler(this.getExecContext(), writer);
        try {
            if (saxReader == null) {
                saxReader = deliveryConfig.getXMLReader();
            }
            if (saxReader == null) {
                saxReader = this.createXMLReader();
            }
            SAXParser.attachXMLReader(saxReader, executionContext);
            this.configureReader(saxReader, this.saxHandler, executionContext, source);
            if (executionContext != null) {
                if (saxReader instanceof HierarchyChangeReader) {
                    ((HierarchyChangeReader)((Object)saxReader)).setHierarchyChangeListener(new XMLReaderHierarchyChangeListener(executionContext));
                }
                saxReader.parse(this.createInputSource(saxReader, source, executionContext.getContentEncoding()));
            } else {
                saxReader.parse(this.createInputSource(saxReader, source, Charset.defaultCharset().name()));
            }
        }
        finally {
            try {
                if (executionContext != null && saxReader instanceof HierarchyChangeReader) {
                    ((HierarchyChangeReader)((Object)saxReader)).setHierarchyChangeListener(null);
                }
            }
            finally {
                block34: {
                    try {
                        if (saxReader == null) break block34;
                        try {
                            SAXParser.detachXMLReader(executionContext);
                        }
                        finally {
                            deliveryConfig.returnXMLReader(saxReader);
                        }
                    }
                    finally {
                        this.saxHandler.detachHandler();
                    }
                }
            }
        }
        return writer;
    }

    public void cleanup() {
        if (this.saxHandler != null) {
            this.saxHandler.cleanup();
        }
    }
}

