/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers.r41;

import java.io.IOException;
import org.milyn.edisax.BufferedSegmentListener;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIParser;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.unedifact.registry.MappingsRegistry;
import org.milyn.xml.hierarchy.HierarchyChangeListener;
import org.xml.sax.SAXException;

class UNHHandler
implements ControlBlockHandler {
    private static Segment unhSegment;
    private static Segment untSegment;
    private static UNTSegmentListener untSegmentListener;
    private HierarchyChangeListener hierarchyChangeListener;

    public UNHHandler(HierarchyChangeListener hierarchyChangeListener) {
        this.hierarchyChangeListener = hierarchyChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        BufferedSegmentReader segmentReader = interchangeContext.getSegmentReader();
        MappingsRegistry registry = interchangeContext.getRegistry();
        interchangeContext.getControlSegmentParser().startElement("interchangeMessage", true);
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(unhSegment, false);
        String[] fields = segmentReader.getCurrentSegmentFields();
        String messageName = fields[2];
        EdifactModel mappingModel = registry.getMappingModel(messageName, segmentReader.getDelimiters());
        try {
            EDIParser parser = interchangeContext.newParser(mappingModel);
            segmentReader.setSegmentListener(untSegmentListener);
            if (this.hierarchyChangeListener != null) {
                this.hierarchyChangeListener.attachXMLReader(parser);
            }
            parser.parse();
        }
        finally {
            segmentReader.setSegmentListener(null);
            if (this.hierarchyChangeListener != null) {
                this.hierarchyChangeListener.detachXMLReader();
            }
        }
        interchangeContext.mapControlSegment(untSegment, true);
        segmentReader.getSegmentBuffer().setLength(0);
        interchangeContext.getControlSegmentParser().endElement("interchangeMessage", true);
    }

    private static void createSegmentsDefs() {
        unhSegment = new Segment();
        unhSegment.setSegcode("UNH");
        unhSegment.setXmltag("UNH");
        unhSegment.setDescription("UNH - Message Header");
        unhSegment.setTruncatable(true);
        unhSegment.addField(new Field("messageRefNum", true));
        unhSegment.addField(new Field("messageIdentifier", true).addComponent(new Component("id", true)).addComponent(new Component("versionNum", true)).addComponent(new Component("releaseNum", true)).addComponent(new Component("controllingAgencyCode", true)).addComponent(new Component("associationAssignedCode", false)).addComponent(new Component("codeListDirVersionNum", false)).addComponent(new Component("typeSubFunctionId", false)));
        unhSegment.addField(new Field("commonAccessRef", false));
        unhSegment.addField(new Field("transferStatus", false).addComponent(new Component("sequence", true)).addComponent(new Component("firstAndLast", false)));
        unhSegment.addField(new Field("subset", false).addComponent(new Component("id", true)).addComponent(new Component("versionNum", false)).addComponent(new Component("releaseNum", false)).addComponent(new Component("controllingAgencyCode", false)));
        unhSegment.addField(new Field("implementationGuideline", false).addComponent(new Component("id", true)).addComponent(new Component("versionNum", false)).addComponent(new Component("releaseNum", false)).addComponent(new Component("controllingAgencyCode", false)));
        unhSegment.addField(new Field("scenario", false).addComponent(new Component("id", true)).addComponent(new Component("versionNum", false)).addComponent(new Component("releaseNum", false)).addComponent(new Component("controllingAgencyCode", false)));
        untSegment = new Segment();
        untSegment.setSegcode("UNT");
        untSegment.setXmltag("UNT");
        untSegment.setDescription("UNT - Message Trailer");
        untSegment.setTruncatable(true);
        untSegment.addField(new Field("segmentCount", true));
        untSegment.addField(new Field("messageRefNum", true));
    }

    static {
        untSegmentListener = new UNTSegmentListener();
        UNHHandler.createSegmentsDefs();
    }

    private static class UNTSegmentListener
    implements BufferedSegmentListener {
        private UNTSegmentListener() {
        }

        public boolean onSegment(BufferedSegmentReader bufferedSegmentReader) {
            String[] fields = bufferedSegmentReader.getCurrentSegmentFields();
            return !fields[0].equals("UNT");
        }
    }
}

