/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.camel.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorAppender;
import org.milyn.event.report.HtmlReportGenerator;
import org.milyn.payload.Exports;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksProcessor
implements Processor,
Service,
CamelContextAware {
    public static final String SMOOKS_EXECUTION_CONTEXT = "CamelSmooksExecutionContext";
    private final Log log = LogFactory.getLog(SmooksProcessor.class);
    private Smooks smooks;
    private String configUri;
    private String reportPath;
    private Set<VisitorAppender> visitorAppenders = new HashSet<VisitorAppender>();
    private Map<String, Visitor> selectorVisitorMap = new HashMap<String, Visitor>();
    private CamelContext camelContext;

    public SmooksProcessor(Smooks smooks, CamelContext camelContext) {
        this.smooks = smooks;
        this.camelContext = camelContext;
    }

    public SmooksProcessor(String configUri, CamelContext camelContext) throws IOException, SAXException {
        this.configUri = configUri;
        this.camelContext = camelContext;
    }

    public void process(Exchange exchange) throws Exception {
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        executionContext.setAttribute(Exchange.class, exchange);
        exchange.getIn().setHeader(SMOOKS_EXECUTION_CONTEXT, (Object)executionContext);
        this.setupSmooksReporting(executionContext);
        Exports exports = Exports.getExports(this.smooks.getApplicationContext());
        if (exports.hasExports()) {
            Result[] results = exports.createResults();
            this.smooks.filterSource(executionContext, this.getSource(exchange), results);
            this.setResultOnBody(exports, results, exchange);
        } else {
            this.smooks.filterSource(executionContext, this.getSource(exchange), new Result[0]);
        }
        executionContext.removeAttribute(Exchange.class);
    }

    protected void setResultOnBody(Exports exports, Result[] results, Exchange exchange) {
        Message message = exchange.getOut();
        List<Object> objects = Exports.extractResults(results, exports);
        if (objects.size() == 1) {
            Object value = objects.get(0);
            message.setBody(value);
        } else {
            message.setBody(objects);
        }
    }

    private void setupSmooksReporting(ExecutionContext executionContext) {
        if (this.reportPath != null) {
            try {
                executionContext.setEventListener(new HtmlReportGenerator(this.reportPath));
            }
            catch (IOException e) {
                this.log.info((Object)("Could not generate Smooks Report. The reportPath specified was [" + this.reportPath + "]."), (Throwable)e);
            }
        }
    }

    private Source getSource(Exchange exchange) {
        Object payload = exchange.getIn().getBody();
        if (payload instanceof Source) {
            return (Source)payload;
        }
        if (payload instanceof Node) {
            return new DOMSource((Node)payload);
        }
        if (payload instanceof InputStream) {
            return new StreamSource((InputStream)payload);
        }
        if (payload instanceof Reader) {
            return new StreamSource((Reader)payload);
        }
        return (Source)exchange.getIn().getBody(Source.class);
    }

    public String getSmooksConfig() {
        return this.configUri;
    }

    public void setSmooksConfig(String smooksConfig) {
        this.configUri = smooksConfig;
    }

    public SmooksProcessor addVisitor(Visitor visitor, String targetSelector) {
        this.selectorVisitorMap.put(targetSelector, visitor);
        return this;
    }

    public SmooksProcessor addVisitor(VisitorAppender appender) {
        this.visitorAppenders.add(appender);
        return this;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public void start() throws Exception {
        if (this.smooks == null) {
            this.smooks = this.createSmooks(this.configUri);
        }
        this.smooks.getApplicationContext().setAttribute(CamelContext.class, this.camelContext);
        this.addAppenders(this.smooks, this.visitorAppenders);
        this.addVisitors(this.smooks, this.selectorVisitorMap);
        this.log.info((Object)(this + " Started"));
    }

    private Smooks createSmooks(String configUri) throws IOException, SAXException {
        if (this.smooks != null) {
            return this.smooks;
        }
        Smooks service = (Smooks)this.camelContext.getRegistry().lookup(Smooks.class.getName());
        if (service != null) {
            this.log.info((Object)("Found smooks in registry: " + service.getClass().getName()));
            return service;
        }
        return new Smooks(configUri);
    }

    private void addAppenders(Smooks smooks, Set<VisitorAppender> appenders) {
        for (VisitorAppender appender : this.visitorAppenders) {
            smooks.addVisitor(appender);
        }
    }

    private void addVisitors(Smooks smooks, Map<String, Visitor> selectorVisitorMap) {
        for (Map.Entry<String, Visitor> entry : selectorVisitorMap.entrySet()) {
            smooks.addVisitor(entry.getValue(), entry.getKey());
        }
    }

    public void stop() throws Exception {
        if (this.smooks != null) {
            this.smooks.close();
            this.smooks = null;
        }
        this.log.info((Object)(this + " Stopped"));
    }

    public String toString() {
        return "SmooksProcessor [configUri=" + this.configUri + "]";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

