/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.config.model;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.List;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.transform.v1.V1TransformsModel;
import org.switchyard.config.util.classpath.ClasspathScanner;
import org.switchyard.config.util.classpath.Filter;
import org.switchyard.config.util.classpath.InstanceOfFilter;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.v1.V1JavaTransformModel;

public class TransformSwitchYardScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1TransformsModel transformsModel = null;
        List<Class<?>> transformerClasses = this.scanForTransformers(input.getURLs());
        for (Class<?> transformer : transformerClasses) {
            if (transformer.isInterface() || Modifier.isAbstract(transformer.getModifiers())) continue;
            V1JavaTransformModel transformModel = new V1JavaTransformModel();
            try {
                Transformer transformerInst = (Transformer)transformer.newInstance();
                transformModel.setFrom(transformerInst.getFrom());
                transformModel.setTo(transformerInst.getTo());
            }
            catch (Exception e) {
                throw new IOException("Error creating instance of Transformer '" + transformer.getName() + "'.  May not contain a public default constructor.", e);
            }
            transformModel.setClazz(transformer.getName());
            if (transformsModel == null) {
                transformsModel = new V1TransformsModel();
                switchyardModel.setTransforms((TransformsModel)transformsModel);
            }
            transformsModel.addTransform((TransformModel)transformModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private List<Class<?>> scanForTransformers(List<URL> urls) throws IOException {
        InstanceOfFilter filter = new InstanceOfFilter(Transformer.class);
        ClasspathScanner scanner = new ClasspathScanner((Filter)filter);
        for (URL url : urls) {
            scanner.scan(url);
        }
        return filter.getMatchedTypes();
    }
}

