/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.config.model;

import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.util.Classes;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.JavaTransformModel;
import org.switchyard.transform.config.model.SmooksTransformModel;
import org.switchyard.transform.internal.smooks.SmooksTransformFactory;

public final class TransformerFactory {
    private TransformerFactory() {
    }

    public static Transformer<?, ?> newTransformer(TransformModel transformModel) {
        if (transformModel instanceof JavaTransformModel) {
            String className = ((JavaTransformModel)transformModel).getClazz();
            try {
                return (Transformer)Classes.forName((String)className, TransformerFactory.class).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error constructing Transformer instance for class '" + className + "'.", e);
            }
        }
        if (transformModel instanceof SmooksTransformModel) {
            return SmooksTransformFactory.newTransformer((SmooksTransformModel)transformModel);
        }
        throw new RuntimeException("Unknown TransformModel type '" + transformModel.getClass().getName() + "'.");
    }
}

