/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelResource;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ModelResourceScanner<M extends Model>
implements Scanner<M> {
    private Type _type;
    private String _resource;
    private URI _uri;
    private URL _url;
    private File _file;
    private InputStream _inputStream;
    private Reader _reader;
    private InputSource _inputSource;
    private Document _document;
    private Element _element;
    private QName _qname;

    public ModelResourceScanner() {
        this("/META-INF/switchyard.xml");
    }

    public ModelResourceScanner(String resource) {
        this._type = Type.RESOURCE;
        this._resource = resource;
    }

    public ModelResourceScanner(URI uri) {
        this._type = Type.URI;
        this._uri = uri;
    }

    public ModelResourceScanner(URL url) {
        this._type = Type.URL;
        this._url = url;
    }

    public ModelResourceScanner(File file) {
        this._type = Type.FILE;
        this._file = file;
    }

    public ModelResourceScanner(InputStream inputStream) {
        this._type = Type.INPUT_STREAM;
        this._inputStream = inputStream;
    }

    public ModelResourceScanner(Reader reader) {
        this._type = Type.READER;
        this._reader = reader;
    }

    public ModelResourceScanner(InputSource inputSource) {
        this._type = Type.INPUT_SOURCE;
        this._inputSource = inputSource;
    }

    public ModelResourceScanner(Document document) {
        this._type = Type.DOCUMENT;
        this._document = document;
    }

    public ModelResourceScanner(Element element) {
        this._type = Type.ELEMENT;
        this._element = element;
    }

    public ModelResourceScanner(QName qname) {
        this._type = Type.QNAME;
        this._qname = qname;
    }

    @Override
    public ScannerOutput<M> scan(ScannerInput<M> input) throws IOException {
        Object model;
        switch (this._type) {
            case RESOURCE: {
                model = (Model)new ModelResource().pull(this._resource);
                break;
            }
            case URI: {
                model = (Model)new ModelResource().pull(this._uri);
                break;
            }
            case URL: {
                model = (Model)new ModelResource().pull(this._url);
                break;
            }
            case FILE: {
                model = (Model)new ModelResource().pull(this._file);
                break;
            }
            case INPUT_STREAM: {
                model = new ModelResource().pull(this._inputStream);
                break;
            }
            case READER: {
                model = new ModelResource().pull(this._reader);
                break;
            }
            case INPUT_SOURCE: {
                model = new ModelResource().pull(this._inputSource);
                break;
            }
            case DOCUMENT: {
                model = new ModelResource().pull(this._document);
                break;
            }
            case ELEMENT: {
                model = new ModelResource().pull(this._element);
                break;
            }
            case QNAME: {
                model = new ModelResource().pull(this._qname);
                break;
            }
            default: {
                model = null;
            }
        }
        return new ScannerOutput<Object>().setModel(model);
    }

    private static enum Type {
        RESOURCE,
        URI,
        URL,
        FILE,
        INPUT_STREAM,
        READER,
        INPUT_SOURCE,
        DOCUMENT,
        ELEMENT,
        QNAME;

    }
}

