/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.util.QNames;

public class V1CompositeReferenceModel
extends BaseNamedModel
implements CompositeReferenceModel {
    private List<BindingModel> _bindings = new ArrayList<BindingModel>();

    public V1CompositeReferenceModel() {
        super(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference"));
    }

    public V1CompositeReferenceModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration binding_config : config.getChildrenStartsWith("binding")) {
            BindingModel binding = (BindingModel)this.readModel(binding_config);
            if (binding == null) continue;
            this._bindings.add(binding);
        }
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public ComponentReferenceModel getComponentReference() {
        block4: {
            int count;
            StringTokenizer st;
            CompositeModel composite;
            block5: {
                QName promote;
                composite = this.getComposite();
                if (composite == null || (promote = this.getPromote()) == null) break block4;
                st = new StringTokenizer(promote.getLocalPart(), "/");
                count = st.countTokens();
                if (count != 1) break block5;
                QName componentName = QNames.create(st.nextToken());
                for (ComponentModel component : composite.getComponents()) {
                    if (!componentName.equals(component.getQName())) continue;
                    List<ComponentReferenceModel> references = component.getReferences();
                    if (references.size() > 0) {
                        return references.get(0);
                    }
                    break block4;
                }
                break block4;
            }
            if (count != 2) break block4;
            QName componentName = QNames.create(st.nextToken());
            QName componentReferenceName = QNames.create(st.nextToken());
            for (ComponentModel component : composite.getComponents()) {
                if (!componentName.equals(component.getQName())) continue;
                for (ComponentReferenceModel reference : component.getReferences()) {
                    if (!componentReferenceName.equals(reference.getQName())) continue;
                    return reference;
                }
            }
        }
        return null;
    }

    @Override
    public QName getPromote() {
        return QNames.create(this.getModelAttribute("promote"));
    }

    @Override
    public CompositeReferenceModel setPromote(QName promote) {
        this.setModelAttribute("promote", promote != null ? promote.toString() : null);
        return this;
    }

    @Override
    public synchronized List<BindingModel> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public synchronized CompositeReferenceModel addBinding(BindingModel binding) {
        this.addChildModel(binding);
        this._bindings.add(binding);
        return this;
    }
}

