/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.metadata.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.metadata.BaseService;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.PayloadTypeName;

public final class JavaService
extends BaseService {
    public static final String TYPE = "java";
    private Class<?> _serviceInterface;

    private JavaService(Set<ServiceOperation> operations, Class<?> serviceInterface) {
        super(operations, TYPE);
        this._serviceInterface = serviceInterface;
    }

    public static JavaService fromClass(Class<?> serviceInterface) {
        return JavaService.fromClass(serviceInterface, null);
    }

    public static JavaService fromClass(Class<?> serviceInterface, String namespaceURI) {
        HashSet<ServiceOperation> ops = new HashSet<ServiceOperation>();
        for (Method m : serviceInterface.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length != 1) {
                throw new RuntimeException("Service operations on a Java interface must have exactly one parameter.");
            }
            QName inputType = JavaService.toMessageType(params[0], namespaceURI);
            if (m.getReturnType().equals(Void.TYPE)) {
                ops.add(new InOnlyOperation(m.getName(), inputType));
                continue;
            }
            QName outputName = JavaService.toMessageType(m.getReturnType(), namespaceURI);
            Class<?>[] exceptions = m.getExceptionTypes();
            QName faultType = null;
            if (exceptions.length > 0) {
                if (exceptions.length > 1) {
                    throw new RuntimeException("Service operations on a Java interface can only throw one type of exception.");
                }
                faultType = JavaService.toMessageType(exceptions[0], namespaceURI);
            }
            ops.add(new InOutOperation(m.getName(), inputType, outputName, faultType));
        }
        return new JavaService(ops, serviceInterface);
    }

    public Class<?> getJavaInterface() {
        return this._serviceInterface;
    }

    public static QName toMessageType(Class<?> javaType) {
        return JavaService.toMessageType(javaType, null);
    }

    public static QName toMessageType(Class<?> javaType, String namespaceURI) {
        PayloadTypeName payloadType = javaType.getAnnotation(PayloadTypeName.class);
        if (payloadType != null) {
            return QName.valueOf(payloadType.value());
        }
        return new QName(namespaceURI, "java:" + javaType.getCanonicalName());
    }
}

