/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePhase;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.internal.DefaultHandlerChain;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.ServiceReferenceImpl;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.Service;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;

public class DomainImpl
implements ServiceDomain {
    private final QName _name;
    private final DefaultHandlerChain _defaultHandlers;
    private final ServiceRegistry _registry;
    private final ExchangeBus _exchangeBus;
    private final TransformerRegistry _transformerRegistry;

    public DomainImpl(QName name, ServiceRegistry registry, ExchangeBus exchangeBus, TransformerRegistry transformerRegistry) {
        this._name = name;
        this._registry = registry;
        this._exchangeBus = exchangeBus;
        this._transformerRegistry = transformerRegistry;
        this._defaultHandlers = new DefaultHandlerChain();
        this._defaultHandlers.addFirst("transformation", (ExchangeHandler)new TransformHandler(this._transformerRegistry));
    }

    public Exchange createExchange(ServiceReference service, ExchangeContract contract) {
        return this.createExchange(service, contract, null);
    }

    public Exchange createExchange(ServiceReference service, ExchangeContract contract, ExchangeHandler handler) {
        Dispatcher inputDispatcher = this._exchangeBus.getDispatcher(service);
        Dispatcher outputDispatcher = null;
        if (handler != null) {
            DefaultHandlerChain replyChain = this._defaultHandlers.copy();
            replyChain.addLast("replyHandler", handler);
            outputDispatcher = this._exchangeBus.createDispatcher(null, replyChain);
        }
        ExchangeImpl exchange = new ExchangeImpl(service, contract, inputDispatcher, outputDispatcher);
        return exchange;
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler) {
        return this.registerService(serviceName, handler, null);
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler, ServiceInterface metadata) {
        if (metadata == null) {
            metadata = new InOutService();
        }
        ServiceReferenceImpl reference = new ServiceReferenceImpl(serviceName, metadata, this);
        DefaultHandlerChain handlers = this._defaultHandlers.copy();
        handlers.addLast("provider", handler);
        Dispatcher ep = this._exchangeBus.createDispatcher(reference, handlers);
        return this._registry.registerService(reference, ep, this).getReference();
    }

    public QName getName() {
        return this._name;
    }

    public TransformerRegistry getTransformerRegistry() {
        return this._transformerRegistry;
    }

    public ServiceReference getService(QName serviceName) {
        List<Service> services = this._registry.getServices(serviceName);
        return services.isEmpty() ? null : services.get(0).getReference();
    }

    private String getEndpointName(QName serviceName, ExchangePhase phase) {
        return this._name + ":" + serviceName + ":" + phase.toString();
    }
}

