/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.spi.Dispatcher;
import org.switchyard.transform.TransformSequence;

public class ExchangeImpl
implements Exchange {
    private static Logger _log = Logger.getLogger(Exchange.class);
    private final String _exchangeId;
    private final ExchangeContract _contract;
    private ExchangePhase _phase;
    private final ServiceReference _service;
    private Message _message;
    private ExchangeState _state = ExchangeState.OK;
    private Dispatcher _inputDispatch;
    private Dispatcher _outputDispatch;
    private final Context _context;

    ExchangeImpl(ServiceReference service, ExchangeContract contract) {
        this(service, contract, null, null);
    }

    ExchangeImpl(ServiceReference service, ExchangeContract contract, Dispatcher input, Dispatcher output) {
        if (contract == null) {
            throw new IllegalArgumentException("null 'contract' arg.");
        }
        if (contract.getInvokerInvocationMetaData() == null) {
            throw new IllegalArgumentException("Invalid 'contract' arg.  No invoker invocation metadata defined on the contract instance.");
        }
        if (contract.getServiceOperation() == null) {
            throw new IllegalArgumentException("Invalid 'contract' arg.  No ServiceOperation defined on the contract instance.");
        }
        ExchangePattern exchangePattern = contract.getServiceOperation().getExchangePattern();
        if (output == null && exchangePattern == ExchangePattern.IN_OUT) {
            throw new RuntimeException("Invalid Exchange construct.  Must supply an output endpoint for an IN_OUT Exchange.");
        }
        this._service = service;
        this._contract = contract;
        this._inputDispatch = input;
        this._outputDispatch = output;
        this._exchangeId = UUID.randomUUID().toString();
        this._context = new DefaultContext();
    }

    public Context getContext() {
        return this._context;
    }

    public ExchangeContract getContract() {
        return this._contract;
    }

    public ServiceReference getService() {
        return this._service;
    }

    public String getId() {
        return this._exchangeId;
    }

    public Message getMessage() {
        return this._message;
    }

    public void send(Message message) {
        this.assertExchangeStateOK();
        if (this._phase == null) {
            this._phase = ExchangePhase.IN;
            this.initInTransformSequence(message);
        } else if (this._phase.equals((Object)ExchangePhase.IN)) {
            this._phase = ExchangePhase.OUT;
            this.initOutTransformSequence(message);
        } else {
            throw new IllegalStateException("Send message not allowed for exchange in phase " + this._phase);
        }
        this.sendInternal(message);
    }

    public void sendFault(Message message) {
        this.assertExchangeStateOK();
        if (this._phase == null) {
            throw new IllegalStateException("Send fault no allowed on new exchanges");
        }
        this._phase = ExchangePhase.OUT;
        this._state = ExchangeState.FAULT;
        this.sendInternal(message);
    }

    public ExchangeState getState() {
        return this._state;
    }

    public Dispatcher getInputDispatcher() {
        return this._inputDispatch;
    }

    public Dispatcher getOutputDispatcher() {
        return this._outputDispatch;
    }

    public void setOutputDispatcher(Dispatcher output) {
        this._outputDispatch = output;
    }

    public void setInputDispatcher(Dispatcher input) {
        this._inputDispatch = input;
    }

    private void sendInternal(Message message) {
        this._message = message;
        switch (this._phase) {
            case IN: {
                this._inputDispatch.dispatch(this);
                break;
            }
            case OUT: {
                if (this._outputDispatch != null) {
                    this._outputDispatch.dispatch(this);
                    break;
                }
                _log.debug((Object)"Unable to send OUT message.  No output endpoint.");
                break;
            }
            default: {
                throw new RuntimeException("No endpoint assigned for exchange phase " + this._phase);
            }
        }
    }

    private void assertExchangeStateOK() {
        if (this._state == ExchangeState.FAULT) {
            throw new IllegalStateException("Exchange instance is in a FAULT state.");
        }
    }

    public Message createMessage() {
        return new DefaultMessage();
    }

    public ExchangePhase getPhase() {
        return this._phase;
    }

    private void initInTransformSequence(Message message) {
        QName exchangeInputType = this._contract.getInvokerInvocationMetaData().getInputType();
        QName serviceOperationInputType = this._contract.getServiceOperation().getInputType();
        if (exchangeInputType != null && serviceOperationInputType != null) {
            TransformSequence.from((QName)exchangeInputType).to(serviceOperationInputType).associateWith(message.getContext());
        }
    }

    private void initOutTransformSequence(Message message) {
        QName serviceOperationOutputType = this._contract.getServiceOperation().getOutputType();
        QName exchangeOutputType = this._contract.getInvokerInvocationMetaData().getOutputType();
        if (serviceOperationOutputType != null && exchangeOutputType != null) {
            TransformSequence.from((QName)serviceOperationOutputType).to(exchangeOutputType).associateWith(message.getContext());
        }
    }
}

