/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class BaseTransformerRegistry
implements TransformerRegistry {
    private static final int DEFAULT_HASHCODE = 32;
    private final ConcurrentHashMap<NameKey, Transformer<?, ?>> _transformers = new ConcurrentHashMap();

    public BaseTransformerRegistry() {
    }

    public BaseTransformerRegistry(Set<Transformer<?, ?>> transformers) {
        for (Transformer<?, ?> t : transformers) {
            this.addTransformer((Transformer)t);
        }
    }

    public BaseTransformerRegistry addTransformer(Transformer<?, ?> transformer) {
        this._transformers.put(new NameKey(transformer.getFrom(), transformer.getTo()), transformer);
        return this;
    }

    public Transformer<?, ?> getTransformer(QName from, QName to) {
        return this._transformers.get(new NameKey(from, to));
    }

    public boolean removeTransformer(Transformer<?, ?> transformer) {
        return this._transformers.remove(new NameKey(transformer.getFrom(), transformer.getTo())) != null;
    }

    private class Key<F, T> {
        private final F _from;
        private final T _to;

        Key(F from, T to) {
            this._from = from;
            this._to = to;
        }

        public F getFrom() {
            return this._from;
        }

        public T getTo() {
            return this._to;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !Key.class.isAssignableFrom(obj.getClass())) {
                return false;
            }
            return this.isEqual(this._from, ((Key)obj).getFrom()) && this.isEqual(this._to, ((Key)obj).getTo());
        }

        public int hashCode() {
            return (this._from != null ? this._from.hashCode() : 31) + (this._to != null ? this._to.hashCode() : 32);
        }

        public String toString() {
            return this._from + "::" + this._to;
        }

        private boolean isEqual(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }

    private class NameKey
    extends Key<QName, QName> {
        NameKey(QName from, QName to) {
            super(from, to);
        }
    }
}

