/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.MapEquivalence;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class APersistentMap
extends AFn
implements IPersistentMap,
Map,
Iterable,
Serializable,
MapEquivalence {
    int _hash = -1;

    public String toString() {
        return RT.printString(this);
    }

    public IPersistentCollection cons(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e2 = (Map.Entry)o;
            return this.assoc(e2.getKey(), e2.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        IPersistentMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e3 = (Map.Entry)es.first();
            ret = ret.assoc(e3.getKey(), e3.getValue());
        }
        return ret;
    }

    public boolean equals(Object obj) {
        return APersistentMap.mapEquals(this, obj);
    }

    public static boolean mapEquals(IPersistentMap m1, Object obj) {
        if (m1 == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != m1.count() || ((Object)m).hashCode() != m1.hashCode()) {
            return false;
        }
        for (ISeq s = m1.seq(); s != null; s = s.next()) {
            Map.Entry e2 = (Map.Entry)s.first();
            boolean found = m.containsKey(e2.getKey());
            if (found && Util.equals(e2.getValue(), m.get(e2.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean equiv(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        if (obj instanceof IPersistentMap && !(obj instanceof MapEquivalence)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e2 = (Map.Entry)s.first();
            boolean found = m.containsKey(e2.getKey());
            if (found && Util.equiv(e2.getValue(), m.get(e2.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this._hash == -1) {
            this._hash = APersistentMap.mapHash(this);
        }
        return this._hash;
    }

    public static int mapHash(IPersistentMap m) {
        int hash2 = 0;
        for (ISeq s = m.seq(); s != null; s = s.next()) {
            Map.Entry e2 = (Map.Entry)s.first();
            hash2 += (e2.getKey() == null ? 0 : e2.getKey().hashCode()) ^ (e2.getValue() == null ? 0 : e2.getValue().hashCode());
        }
        return hash2;
    }

    public Object invoke(Object arg1) throws Exception {
        return this.valAt(arg1);
    }

    public Object invoke(Object arg1, Object notFound) throws Exception {
        return this.valAt(arg1, notFound);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return APersistentMap.this.iterator();
            }

            public int size() {
                return APersistentMap.this.count();
            }

            public int hashCode() {
                return APersistentMap.this.hashCode();
            }

            public boolean contains(Object o) {
                Map.Entry e2;
                IMapEntry found;
                return o instanceof Map.Entry && (found = APersistentMap.this.entryAt((e2 = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e2.getValue());
            }
        };
    }

    public Object get(Object key2) {
        return this.valAt(key2);
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e2 = (Map.Entry)mi.next();
                        return e2.getKey();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return APersistentMap.this.count();
            }

            public boolean contains(Object o) {
                return APersistentMap.this.containsKey(o);
            }
        };
    }

    public Object put(Object key2, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.count();
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e2 = (Map.Entry)mi.next();
                        return e2.getValue();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return APersistentMap.this.count();
            }
        };
    }

    public static class ValSeq
    extends ASeq {
        ISeq seq;

        public static ValSeq create(ISeq seq2) {
            if (seq2 == null) {
                return null;
            }
            return new ValSeq(seq2);
        }

        private ValSeq(ISeq seq2) {
            this.seq = seq2;
        }

        private ValSeq(IPersistentMap meta2, ISeq seq2) {
            super(meta2);
            this.seq = seq2;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        public ISeq next() {
            return ValSeq.create(this.seq.next());
        }

        public ValSeq withMeta(IPersistentMap meta2) {
            return new ValSeq(meta2, this.seq);
        }
    }

    public static class KeySeq
    extends ASeq {
        ISeq seq;

        public static KeySeq create(ISeq seq2) {
            if (seq2 == null) {
                return null;
            }
            return new KeySeq(seq2);
        }

        private KeySeq(ISeq seq2) {
            this.seq = seq2;
        }

        private KeySeq(IPersistentMap meta2, ISeq seq2) {
            super(meta2);
            this.seq = seq2;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        public ISeq next() {
            return KeySeq.create(this.seq.next());
        }

        public KeySeq withMeta(IPersistentMap meta2) {
            return new KeySeq(meta2, this.seq);
        }
    }
}

