/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.clojure;

import java.io.File;
import java.io.IOException;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.component.clojure.config.model.ClojureComponentImplementationModel;
import org.switchyard.component.clojure.config.model.ClojureScriptModel;
import org.switchyard.component.clojure.config.model.v1.V1ClojureComponentImplementationModel;
import org.switchyard.component.clojure.config.model.v1.V1ClojureScriptModel;
import org.switchyard.tools.forge.clojure.ClojureBuilderException;

public class ClojureModelBuilder {
    private String _inlineScript;
    private boolean _emptyInlineScript;
    private String _externalScriptPath;
    private boolean _emptyExternalScriptPath;
    private boolean _injectExchange;

    public ClojureModelBuilder injectExchange(boolean inject) {
        this._injectExchange = inject;
        return this;
    }

    public ClojureModelBuilder inlineScript(String script) throws ClojureBuilderException {
        this._inlineScript = script;
        return this;
    }

    public ClojureModelBuilder emptyInlineScript(boolean empty) throws ClojureBuilderException {
        this._emptyInlineScript = empty;
        return this;
    }

    public ClojureModelBuilder externalScriptPath(String scriptPath) {
        this._externalScriptPath = scriptPath;
        return this;
    }

    public ClojureModelBuilder emptyExternalScriptPath(boolean empty) throws ClojureBuilderException {
        this._emptyExternalScriptPath = empty;
        return this;
    }

    public ClojureComponentImplementationModel build() throws ClojureBuilderException {
        V1ClojureComponentImplementationModel implModel = new V1ClojureComponentImplementationModel();
        if (this.isInlineScript()) {
            try {
                String clojureScript = this._emptyInlineScript ? "" : (String)new StringPuller().pull(new File(this._inlineScript));
                V1ClojureScriptModel scriptModel = new V1ClojureScriptModel();
                scriptModel.setScript(clojureScript);
                implModel.setScriptModel((ClojureScriptModel)scriptModel);
            }
            catch (IOException e) {
                throw new ClojureBuilderException(e.getMessage(), e);
            }
        } else if (this.inExternalScriptPath()) {
            String path = this._emptyExternalScriptPath ? "" : this._externalScriptPath;
            implModel.setScriptFile(path);
        } else {
            throw new ClojureBuilderException("None of the available options were configured. Available options: " + this.toString());
        }
        implModel.setInjectExchange(Boolean.valueOf(this._injectExchange));
        return implModel;
    }

    private boolean inExternalScriptPath() {
        return this._externalScriptPath != null || this._emptyExternalScriptPath;
    }

    private boolean isInlineScript() {
        return this._inlineScript != null || this._emptyInlineScript;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[inlineScript=").append(this._inlineScript);
        sb.append(",emptyInlineScript=").append(this._emptyInlineScript);
        sb.append(",externalScriptPath=").append(this._externalScriptPath);
        sb.append(",emptyExternalScriptPath=").append(this._emptyExternalScriptPath);
        sb.append(",injectExchange=").append(this._injectExchange);
        sb.append("]");
        return sb.toString();
    }
}

