/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.seam.forge.project.dependencies.Dependency;
import org.jboss.seam.forge.project.dependencies.DependencyBuilder;
import org.jboss.seam.forge.project.facets.BaseFacet;
import org.jboss.seam.forge.project.facets.DependencyFacet;
import org.jboss.seam.forge.project.facets.PackagingFacet;
import org.jboss.seam.forge.project.packaging.PackagingType;
import org.jboss.seam.forge.shell.Shell;

public abstract class AbstractFacet
extends BaseFacet {
    public static final String VERSION = "switchyard.version";
    private List<String> _depends = new LinkedList<String>();
    @Inject
    private Shell _shell;

    protected AbstractFacet(String ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            this._depends = Arrays.asList(dependencies);
        }
    }

    public boolean install() {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (!this._depends.isEmpty()) {
            List versions = deps.resolveAvailableVersions(this._depends.get(0) + ":[,]");
            Dependency version = (Dependency)this._shell.promptChoiceTyped("Please select a version to install:", versions);
            deps.setProperty(VERSION, version.getVersion());
            for (String artifact : this._depends) {
                DependencyBuilder dep = DependencyBuilder.create((String)(artifact + ":${" + VERSION + "}"));
                deps.addDependency((Dependency)dep);
            }
        }
        return true;
    }

    public boolean isInstalled() {
        boolean installed = false;
        if (!this._depends.isEmpty()) {
            DependencyBuilder dep = DependencyBuilder.create((String)this._depends.get(0));
            PackagingType packagingType = ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getPackagingType();
            installed = ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasDependency((Dependency)dep) && PackagingType.JAR.equals((Object)packagingType);
        }
        return installed;
    }

    protected Shell getShell() {
        return this._shell;
    }
}

