/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.shell.buffers.JLineScreenBuffer;
import org.jboss.forge.shell.console.jline.Terminal;
import org.jboss.forge.shell.console.jline.TerminalFactory;
import org.jboss.forge.shell.integration.BufferManager;
import org.jboss.forge.test.AbstractShellTest;
import org.junit.Assert;
import org.junit.Before;
import org.switchyard.common.version.Versions;

public abstract class GenericTestForge
extends AbstractShellTest {
    private static String switchyardVersion;
    private static OutputStream outputStream;
    private static String switchyardVersionSuccessMsg;
    private static final String FORGE_APP_NAME = "ForgeTestApp";

    public GenericTestForge() {
        switchyardVersion = Versions.getSwitchYardVersion();
        switchyardVersionSuccessMsg = "SwitchYard version " + switchyardVersion;
    }

    @Before
    public void prepareSwitchyardForge() throws IOException {
        try {
            this.resetOutputStream();
            this.initializeJavaProject();
            this.queueInputLines(new String[]{FORGE_APP_NAME});
            this.getShell().execute("project install-facet switchyard");
            this.getShell().execute("switchyard get-version");
            Assert.assertTrue((boolean)outputStream.toString().contains(switchyardVersionSuccessMsg));
            System.out.println(outputStream);
            this.resetOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(outputStream);
        }
    }

    protected void mavenBuildSkipTest() {
        String[] mvnCommand = new String[]{"package", "-e", "-Dmaven.test.skip=true"};
        ((MavenCoreFacet)this.getProject().getFacet(MavenCoreFacet.class)).executeMaven(mvnCommand);
    }

    protected void build() {
        try {
            this.getShell().execute("build");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetOutputStream() {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        outputStream = new OutputStream(){
            private StringBuilder _stringBuilder = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                this._stringBuilder.append((char)b);
            }

            public String toString() {
                return this._stringBuilder.toString();
            }
        };
        TerminalFactory.configure((TerminalFactory.Type)TerminalFactory.Type.AUTO);
        Terminal terminal = TerminalFactory.get();
        JLineScreenBuffer screenBuffer = new JLineScreenBuffer(terminal, outputStream);
        this.getShell().registerBufferManager((BufferManager)screenBuffer);
    }

    public static String getSwitchyardVersion() {
        return switchyardVersion;
    }

    public static String getOutput() {
        return outputStream.toString();
    }
}

