/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.packaging.PackagingType;

public abstract class AbstractFacet
extends BaseFacet {
    public static final String VERSION = "switchyard.version";
    private List<String> _depends = new LinkedList<String>();

    protected AbstractFacet(String ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            this._depends = Arrays.asList(dependencies);
        }
    }

    protected void installDependencies() {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (!this._depends.isEmpty()) {
            for (String artifact : this._depends) {
                DependencyBuilder dep = DependencyBuilder.create((String)(artifact + ":${" + VERSION + "}"));
                deps.addDirectDependency((Dependency)dep);
            }
        }
    }

    public boolean isInstalled() {
        boolean installed = false;
        if (!this._depends.isEmpty()) {
            DependencyBuilder dep = DependencyBuilder.create((String)this._depends.get(0));
            PackagingType packagingType = ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getPackagingType();
            installed = ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasDirectDependency((Dependency)dep) && PackagingType.JAR.equals((Object)packagingType);
        }
        return installed;
    }

    public String getVersion() {
        return ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).getProperty(VERSION);
    }

    public void setVersion(String version) {
        ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).setProperty(VERSION, version);
    }
}

